/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterPublicKey;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterPublicKeyMapEntry;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ACryptFilterPublicKey;
import org.verapdf.model.alayer.ACryptFilterPublicKeyMap;
import org.verapdf.model.alayer.ACryptFilterPublicKeyMapEntry;
import org.verapdf.model.baselayer.Object;

public class GFACryptFilterPublicKeyMap
extends GFAObject
implements ACryptFilterPublicKeyMap {
    public GFACryptFilterPublicKeyMap(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACryptFilterPublicKeyMap");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "DefEmbeddedFile": {
                return this.getDefEmbeddedFile();
            }
            case "DefaultCryptFilter": {
                return this.getDefaultCryptFilter();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACryptFilterPublicKeyMapEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterPublicKeyMapEntry> getEntries1_5() {
        LinkedList<GFACryptFilterPublicKeyMapEntry> list = new LinkedList<GFACryptFilterPublicKeyMapEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("DefEmbeddedFile".equals(key.getValue()) || "DefaultCryptFilter".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFACryptFilterPublicKeyMapEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<ACryptFilterPublicKey> getDefEmbeddedFile() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDefEmbeddedFile1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterPublicKey> getDefEmbeddedFile1_5() {
        COSObject object = this.getDefEmbeddedFileValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilterPublicKey> list = new ArrayList<GFACryptFilterPublicKey>(1);
            list.add(new GFACryptFilterPublicKey((COSDictionary)object.getDirectBase(), this.baseObject, "DefEmbeddedFile"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterPublicKey> getDefaultCryptFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDefaultCryptFilter1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterPublicKey> getDefaultCryptFilter1_5() {
        COSObject object = this.getDefaultCryptFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilterPublicKey> list = new ArrayList<GFACryptFilterPublicKey>(1);
            list.add(new GFACryptFilterPublicKey((COSDictionary)object.getDirectBase(), this.baseObject, "DefaultCryptFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsDefEmbeddedFile() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DefEmbeddedFile"));
    }

    public COSObject getDefEmbeddedFileValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DefEmbeddedFile"));
        return object;
    }

    @Override
    public String getDefEmbeddedFileType() {
        COSObject DefEmbeddedFile = this.getDefEmbeddedFileValue();
        return this.getObjectType(DefEmbeddedFile);
    }

    @Override
    public Boolean getDefEmbeddedFileHasTypeDictionary() {
        COSObject DefEmbeddedFile = this.getDefEmbeddedFileValue();
        return GFACryptFilterPublicKeyMap.getHasTypeDictionary(DefEmbeddedFile);
    }

    @Override
    public Boolean getcontainsDefaultCryptFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DefaultCryptFilter"));
    }

    public COSObject getDefaultCryptFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DefaultCryptFilter"));
        return object;
    }

    @Override
    public String getDefaultCryptFilterType() {
        COSObject DefaultCryptFilter = this.getDefaultCryptFilterValue();
        return this.getObjectType(DefaultCryptFilter);
    }

    @Override
    public Boolean getDefaultCryptFilterHasTypeDictionary() {
        COSObject DefaultCryptFilter = this.getDefaultCryptFilterValue();
        return GFACryptFilterPublicKeyMap.getHasTypeDictionary(DefaultCryptFilter);
    }
}

