/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBasePair;
import org.verapdf.cos.COSDirect;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSDictionary
extends COSDirect {
    public static final String SIZE = "size";
    public static final String DICTIONARY = "dictionary";
    private Map<ASAtom, COSObject> entries;

    protected COSDictionary() {
        this.entries = new HashMap<ASAtom, COSObject>();
    }

    protected COSDictionary(ASAtom key, COSObject value) {
        this();
        this.setKey(key, value);
    }

    protected COSDictionary(ASAtom key, boolean value) {
        this();
        this.setBooleanKey(key, value);
    }

    protected COSDictionary(ASAtom key, int value) {
        this();
        this.setIntegerKey(key, value);
    }

    protected COSDictionary(ASAtom key, double value) {
        this();
        this.setRealKey(key, value);
    }

    protected COSDictionary(ASAtom key, String value) {
        this();
        this.setStringKey(key, value);
    }

    protected COSDictionary(ASAtom key, ASAtom value) {
        this();
        this.setNameKey(key, value);
    }

    protected COSDictionary(ASAtom key, int size, COSObject[] value) {
        this();
        this.setArrayKey(key, size, value);
    }

    protected COSDictionary(ASAtom key, int size, double[] value) {
        this();
        this.setArrayKey(key, size, value);
    }

    protected COSDictionary(COSDictionary dict) {
        this.entries = dict.entries;
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_DICT;
    }

    public static COSObject construct() {
        return new COSObject(new COSDictionary());
    }

    public static COSObject construct(ASAtom key, COSObject value) {
        return new COSObject(new COSDictionary(key, value));
    }

    public static COSObject construct(ASAtom key, boolean value) {
        return new COSObject(new COSDictionary(key, value));
    }

    public static COSObject construct(ASAtom key, int value) {
        return new COSObject(new COSDictionary(key, value));
    }

    public static COSObject construct(ASAtom key, double value) {
        return new COSObject(new COSDictionary(key, value));
    }

    public static COSObject construct(ASAtom key, String value) {
        return new COSObject(new COSDictionary(key, value));
    }

    public static COSObject construct(ASAtom key, ASAtom value) {
        return new COSObject(new COSDictionary(key, value));
    }

    public static COSObject construct(ASAtom key, int size, COSObject[] value) {
        return new COSObject(new COSDictionary(key, size, value));
    }

    public static COSObject construct(ASAtom key, int size, double[] value) {
        return new COSObject(new COSDictionary(key, size, value));
    }

    public static COSObject construct(COSDictionary dict) {
        return new COSObject(new COSDictionary(dict));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromDictionary(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromDictionary(this);
    }

    @Override
    public Integer size() {
        return this.entries.size();
    }

    @Override
    public Boolean knownKey(ASAtom key) {
        return this.entries.containsKey(key);
    }

    @Override
    public COSObject getKey(ASAtom key) {
        COSObject value = this.entries.get(key);
        return value != null ? value : new COSObject();
    }

    @Override
    public boolean setKey(ASAtom key, COSObject value) {
        if (value.empty() || value.get() instanceof COSNull) {
            this.entries.remove(key);
        } else {
            this.entries.put(key, value);
        }
        return true;
    }

    @Override
    public Boolean getBooleanKey(ASAtom key) {
        return this.getKey(key).getBoolean();
    }

    @Override
    public boolean setBooleanKey(ASAtom key, boolean value) {
        COSObject obj = new COSObject();
        obj.setBoolean(value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public Long getIntegerKey(ASAtom key) {
        return this.getKey(key).getInteger();
    }

    @Override
    public boolean setIntegerKey(ASAtom key, long value) {
        COSObject obj = new COSObject();
        obj.setInteger(value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public Double getRealKey(ASAtom key) {
        return this.getKey(key).getReal();
    }

    @Override
    public boolean setRealKey(ASAtom key, double value) {
        COSObject obj = new COSObject();
        obj.setReal(value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public String getStringKey(ASAtom key) {
        COSObject object = this.getKey(key);
        if (object.getType() == COSObjType.COS_NAME) {
            return null;
        }
        return object.getString();
    }

    @Override
    public boolean setStringKey(ASAtom key, String value) {
        COSObject obj = new COSObject();
        obj.setString(value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public final ASAtom getNameKey(ASAtom key) {
        return this.getKey(key).getName();
    }

    @Override
    public final String getNameKeyStringValue(ASAtom key) {
        ASAtom value = this.getNameKey(key);
        return value != null ? value.getValue() : null;
    }

    @Override
    public boolean setNameKey(ASAtom key, ASAtom value) {
        COSObject obj = new COSObject();
        obj.setName(value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key) {
        COSObject obj = new COSObject();
        obj.setArray();
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key, COSObject array) {
        this.entries.put(key, array);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key, int size, COSObject[] value) {
        COSObject obj = new COSObject();
        obj.setArray(size, value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key, int size, double[] value) {
        COSObject obj = new COSObject();
        obj.setArray(size, value);
        this.entries.put(key, obj);
        return true;
    }

    @Override
    public void removeKey(ASAtom key) {
        this.entries.remove(key);
    }

    public Set<Map.Entry<ASAtom, COSObject>> getEntrySet() {
        return this.entries.entrySet();
    }

    @Override
    public Set<ASAtom> getKeySet() {
        return this.entries.keySet();
    }

    @Override
    public Collection<COSObject> getValues() {
        return this.entries.values();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).get());
        }
        LinkedList<COSBasePair> checkedObjects = new LinkedList<COSBasePair>();
        return this.equals(obj, checkedObjects);
    }

    @Override
    boolean equals(Object obj, List<COSBasePair> checkedObjects) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).get());
        }
        if (COSBasePair.listContainsPair(checkedObjects, this, (COSBase)obj)) {
            return true;
        }
        COSBasePair.addPairToList(checkedObjects, this, (COSBase)obj);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        COSDictionary that = (COSDictionary)obj;
        if (!that.size().equals(this.size())) {
            return false;
        }
        Set<ASAtom> set1 = this.getKeySet();
        if (!set1.equals(that.getKeySet())) {
            return false;
        }
        for (ASAtom name : set1) {
            COSBase cosBase2;
            COSBase cosBase1 = this.getKey(name).get();
            if (cosBase1.equals(cosBase2 = that.getKey(name).get(), checkedObjects)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "dictionary(size = " + this.size() + ")";
    }
}

