/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports.multithread.writer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.writer.AbstractXmlReportWriter;
import org.xml.sax.SAXException;

public class MrrReportWriter
extends AbstractXmlReportWriter {
    private static final Logger LOGGER = Logger.getLogger(MrrReportWriter.class.getCanonicalName());
    private final String REPORT_TAG = "report";
    private final String BUILD_INFORMATION_TAG = "buildInformation";
    private final String JOBS_TAG = "jobs";
    private final String JOB_TAG = "job";

    MrrReportWriter(PrintWriter outputStreamWriter, PrintWriter errorStreamWriter) throws XMLStreamException, ParserConfigurationException, SAXException {
        super(outputStreamWriter, errorStreamWriter);
    }

    @Override
    public void write(ResultStructure result) {
        try {
            File reportFile = result.getReportFile();
            if (this.isFirstReport) {
                this.writer.writeStartElement("report");
                this.printFirstReport(reportFile);
                this.isFirstReport = false;
            } else {
                super.printTag(reportFile, "job", true);
            }
            this.deleteTemp(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't write element", e);
        }
    }

    @Override
    public void endDocument() {
        this.writeEndElement();
        super.endDocument();
    }

    public void writeEndElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            LOGGER.log(Level.SEVERE, "Can't write end element", e);
        }
    }

    @Override
    public void printFirstReport(File report) throws SAXException, IOException, XMLStreamException {
        this.printTag(report, "buildInformation", false);
        this.writer.writeStartElement("jobs");
        this.printTag(report, "job", true);
    }
}

