/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterMap;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ACryptFilterMap;
import org.verapdf.model.alayer.AEncryptionStandard;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionStandard
extends GFAObject
implements AEncryptionStandard {
    public GFAEncryptionStandard(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionStandard");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACryptFilterMap> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterMap> getCF1_5() {
        COSObject object = this.getCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilterMap> list = new ArrayList<GFACryptFilterMap>(1);
            list.add(new GFACryptFilterMap((COSDictionary)object.getDirectBase(), this.baseObject, "CF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CF"));
    }

    public COSObject getCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CF"));
        return object;
    }

    @Override
    public Boolean getCFHasTypeDictionary() {
        COSObject object = this.getCFValue();
        return GFAEncryptionStandard.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EFF"));
    }

    public COSObject getEFFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EFF"));
        return object;
    }

    @Override
    public Boolean getEFFHasTypeName() {
        COSObject object = this.getEFFValue();
        return GFAEncryptionStandard.getHasTypeName(object);
    }

    @Override
    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject object = this.getEncryptMetadataValue();
        return GFAEncryptionStandard.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return COSName.construct("Standard");
            }
        }
        return null;
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        if (object == null || object.empty()) {
            object = this.getFilterDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject object = this.getFilterValue();
        return GFAEncryptionStandard.getHasTypeName(object);
    }

    @Override
    public String getFilterNameValue() {
        COSObject object = this.getFilterValue();
        return GFAEncryptionStandard.getNameValue(object);
    }

    @Override
    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("KDFSalt"));
    }

    public COSObject getKDFSaltValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("KDFSalt"));
        return object;
    }

    @Override
    public Boolean getisKDFSaltIndirect() {
        COSObject object = this.getKDFSaltValue();
        return GFAEncryptionStandard.getisIndirect(object);
    }

    @Override
    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject object = this.getKDFSaltValue();
        return GFAEncryptionStandard.getHasTypeStringByte(object);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return COSInteger.construct(40L);
            }
        }
        return null;
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        if (object == null || object.empty()) {
            object = this.getLengthDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.getLengthValue();
        return GFAEncryptionStandard.getHasTypeInteger(object);
    }

    @Override
    public Long getLengthIntegerValue() {
        COSObject object = this.getLengthValue();
        return GFAEncryptionStandard.getIntegerValue(object);
    }

    @Override
    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom("O"));
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("O"));
        return object;
    }

    @Override
    public Boolean getOHasTypeStringByte() {
        COSObject object = this.getOValue();
        return GFAEncryptionStandard.getHasTypeStringByte(object);
    }

    @Override
    public Long getOStringSize() {
        COSObject object = this.getOValue();
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsOE() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OE"));
    }

    public COSObject getOEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OE"));
        return object;
    }

    @Override
    public Boolean getOEHasTypeStringByte() {
        COSObject object = this.getOEValue();
        return GFAEncryptionStandard.getHasTypeStringByte(object);
    }

    @Override
    public Long getOEStringSize() {
        COSObject object = this.getOEValue();
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        return object;
    }

    @Override
    public Boolean getPHasTypeBitmask() {
        COSObject object = this.getPValue();
        return GFAEncryptionStandard.getHasTypeBitmask(object);
    }

    @Override
    public Long getPBitmaskValue() {
        COSObject object = this.getPValue();
        return GFAEncryptionStandard.getBitmaskValue(object);
    }

    @Override
    public Boolean getcontainsPerms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Perms"));
    }

    public COSObject getPermsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Perms"));
        return object;
    }

    @Override
    public Boolean getPermsHasTypeStringByte() {
        COSObject object = this.getPermsValue();
        return GFAEncryptionStandard.getHasTypeStringByte(object);
    }

    @Override
    public Boolean getcontainsR() {
        return this.baseObject.knownKey(ASAtom.getASAtom("R"));
    }

    public COSObject getRValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("R"));
        return object;
    }

    @Override
    public Boolean getRHasTypeInteger() {
        COSObject object = this.getRValue();
        return GFAEncryptionStandard.getHasTypeInteger(object);
    }

    @Override
    public Long getRIntegerValue() {
        COSObject object = this.getRValue();
        return GFAEncryptionStandard.getIntegerValue(object);
    }

    @Override
    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StmF"));
    }

    public COSObject getStmFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStmFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StmF"));
        if (object == null || object.empty()) {
            object = this.getStmFDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getStmFHasTypeName() {
        COSObject object = this.getStmFValue();
        return GFAEncryptionStandard.getHasTypeName(object);
    }

    @Override
    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StrF"));
    }

    public COSObject getStrFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStrFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StrF"));
        if (object == null || object.empty()) {
            object = this.getStrFDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getStrFHasTypeName() {
        COSObject object = this.getStrFValue();
        return GFAEncryptionStandard.getHasTypeName(object);
    }

    @Override
    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SubFilter"));
    }

    public COSObject getSubFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SubFilter"));
        return object;
    }

    @Override
    public Boolean getSubFilterHasTypeName() {
        COSObject object = this.getSubFilterValue();
        return GFAEncryptionStandard.getHasTypeName(object);
    }

    @Override
    public Boolean getcontainsU() {
        return this.baseObject.knownKey(ASAtom.getASAtom("U"));
    }

    public COSObject getUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("U"));
        return object;
    }

    @Override
    public Boolean getUHasTypeStringByte() {
        COSObject object = this.getUValue();
        return GFAEncryptionStandard.getHasTypeStringByte(object);
    }

    @Override
    public Long getUStringSize() {
        COSObject object = this.getUValue();
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsUE() {
        return this.baseObject.knownKey(ASAtom.getASAtom("UE"));
    }

    public COSObject getUEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("UE"));
        return object;
    }

    @Override
    public Boolean getUEHasTypeStringByte() {
        COSObject object = this.getUEValue();
        return GFAEncryptionStandard.getHasTypeStringByte(object);
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public Boolean getVHasTypeInteger() {
        COSObject object = this.getVValue();
        return GFAEncryptionStandard.getHasTypeInteger(object);
    }

    @Override
    public Long getVIntegerValue() {
        COSObject object = this.getVValue();
        return GFAEncryptionStandard.getIntegerValue(object);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    @Override
    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

