/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfObjectStreams;
import org.verapdf.gf.model.impl.arlington.GFAAuthCode;
import org.verapdf.gf.model.impl.arlington.GFACatalog;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFALinearizationParameterDict;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFATrailerIDArray;
import org.verapdf.gf.model.impl.arlington.GFAXRefStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfObjectStreams;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.alayer.ACatalog;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AFileTrailer;
import org.verapdf.model.alayer.ALinearizationParameterDict;
import org.verapdf.model.alayer.ATrailerIDArray;
import org.verapdf.model.alayer.AXRefStream;
import org.verapdf.tools.StaticResources;

public class GFAFileTrailer
extends GFAObject
implements AFileTrailer {
    public GFAFileTrailer(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFileTrailer");
        GFAObject.clearAllContainers();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AuthCode": {
                return this.getAuthCode();
            }
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "entryID": {
                return this.getentryID();
            }
            case "Info": {
                return this.getInfo();
            }
            case "LinearizationParameterDict": {
                return this.getLinearizationParameterDict();
            }
            case "ObjectStreams": {
                return this.getObjectStreams();
            }
            case "Root": {
                return this.getRoot();
            }
            case "XRefStream": {
                return this.getXRefStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AAuthCode> getAuthCode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAuthCode2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode2_0() {
        COSObject object = this.getAuthCodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAAuthCode> list = new ArrayList<GFAAuthCode>(1);
            list.add(new GFAAuthCode((COSDictionary)object.getDirectBase(), this.baseObject, "AuthCode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getEncrypt1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt1_1() {
        COSObject object = this.getEncryptValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary1_1(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary1_1(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<ATrailerIDArray> getentryID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getentryID1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID1_1() {
        COSObject object = this.getentryIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFATrailerIDArray> list = new ArrayList<GFATrailerIDArray>(1);
            list.add(new GFATrailerIDArray((COSArray)object.getDirectBase(), this.baseObject, "ID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo() {
        return this.getInfo1_0();
    }

    private List<ADocInfo> getInfo1_0() {
        COSObject object = this.getInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSDictionary)object.getDirectBase(), this.baseObject, "Info"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ALinearizationParameterDict> getLinearizationParameterDict() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getLinearizationParameterDict1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<ALinearizationParameterDict> getLinearizationParameterDict1_2() {
        COSObject object = this.getLinearizationParameterDictValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFALinearizationParameterDict> list = new ArrayList<GFALinearizationParameterDict>(1);
            list.add(new GFALinearizationParameterDict((COSDictionary)object.getDirectBase(), this.baseObject, "LinearizationParameterDict"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfObjectStreams> getObjectStreams() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getObjectStreams1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfObjectStreams> getObjectStreams1_5() {
        COSObject object = this.getObjectStreamsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfObjectStreams> list = new ArrayList<GFAArrayOfObjectStreams>(1);
            list.add(new GFAArrayOfObjectStreams((COSArray)object.getDirectBase(), this.baseObject, "ObjectStreams"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot() {
        return this.getRoot1_0();
    }

    private List<ACatalog> getRoot1_0() {
        COSObject object = this.getRootValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACatalog> list = new ArrayList<GFACatalog>(1);
            list.add(new GFACatalog((COSDictionary)object.getDirectBase(), this.baseObject, "Root"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AXRefStream> getXRefStream() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getXRefStream1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AXRefStream> getXRefStream1_5() {
        COSObject object = this.getXRefStreamValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXRefStream> list = new ArrayList<GFAXRefStream>(1);
            list.add(new GFAXRefStream((COSStream)object.getDirectBase(), this.baseObject, "XRefStream"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAuthCode() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AuthCode"));
    }

    public COSObject getAuthCodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AuthCode"));
        return object;
    }

    @Override
    public Boolean getisAuthCodeIndirect() {
        COSObject object = this.getAuthCodeValue();
        return GFAFileTrailer.getisIndirect(object);
    }

    @Override
    public Boolean getAuthCodeHasTypeDictionary() {
        COSObject object = this.getAuthCodeValue();
        return GFAFileTrailer.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Encrypt"));
    }

    public COSObject getEncryptValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        return object;
    }

    @Override
    public Boolean getEncryptHasTypeDictionary() {
        COSObject object = this.getEncryptValue();
        return GFAFileTrailer.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ID"));
        return object;
    }

    @Override
    public Boolean getisentryIDIndirect() {
        COSObject object = this.getentryIDValue();
        return GFAFileTrailer.getisIndirect(object);
    }

    @Override
    public Boolean getentryIDHasTypeArray() {
        COSObject object = this.getentryIDValue();
        return GFAFileTrailer.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Info"));
        return object;
    }

    @Override
    public Boolean getisInfoIndirect() {
        COSObject object = this.getInfoValue();
        return GFAFileTrailer.getisIndirect(object);
    }

    @Override
    public Boolean getInfoHasTypeDictionary() {
        COSObject object = this.getInfoValue();
        return GFAFileTrailer.getHasTypeDictionary(object);
    }

    public COSObject getLinearizationParameterDictValue() {
        COSObject object = StaticResources.getDocument().getDocument().getLinearizationDictionary();
        return object;
    }

    public COSObject getObjectStreamsValue() {
        COSObject object = new COSObject(new COSArray(StaticResources.getDocument().getDocument().getObjectStreamsList()));
        return object;
    }

    @Override
    public Boolean getcontainsPrev() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Prev"));
    }

    public COSObject getPrevValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Prev"));
        return object;
    }

    @Override
    public Boolean getisPrevIndirect() {
        COSObject object = this.getPrevValue();
        return GFAFileTrailer.getisIndirect(object);
    }

    @Override
    public Boolean getPrevHasTypeInteger() {
        COSObject object = this.getPrevValue();
        return GFAFileTrailer.getHasTypeInteger(object);
    }

    @Override
    public Long getPrevIntegerValue() {
        COSObject object = this.getPrevValue();
        return GFAFileTrailer.getIntegerValue(object);
    }

    @Override
    public Boolean getcontainsRoot() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Root"));
    }

    public COSObject getRootValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Root"));
        return object;
    }

    @Override
    public Boolean getisRootIndirect() {
        COSObject object = this.getRootValue();
        return GFAFileTrailer.getisIndirect(object);
    }

    @Override
    public Boolean getRootHasTypeDictionary() {
        COSObject object = this.getRootValue();
        return GFAFileTrailer.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Size"));
        return object;
    }

    @Override
    public Boolean getisSizeIndirect() {
        COSObject object = this.getSizeValue();
        return GFAFileTrailer.getisIndirect(object);
    }

    @Override
    public Boolean getSizeHasTypeInteger() {
        COSObject object = this.getSizeValue();
        return GFAFileTrailer.getHasTypeInteger(object);
    }

    @Override
    public Long getSizeIntegerValue() {
        COSObject object = this.getSizeValue();
        return GFAFileTrailer.getIntegerValue(object);
    }

    @Override
    public Boolean getcontainsXRefStm() {
        return this.baseObject.knownKey(ASAtom.getASAtom("XRefStm"));
    }

    public COSObject getXRefStmValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("XRefStm"));
        return object;
    }

    @Override
    public Boolean getXRefStmHasTypeInteger() {
        COSObject object = this.getXRefStmValue();
        return GFAFileTrailer.getHasTypeInteger(object);
    }

    @Override
    public Long getXRefStmIntegerValue() {
        COSObject object = this.getXRefStmValue();
        return GFAFileTrailer.getIntegerValue(object);
    }

    @Override
    public Boolean getcontainsXRefStream() {
        return this.getcontainsXRefStm();
    }

    public COSObject getXRefStreamValue() {
        Long offset = this.getXRefStmIntegerValue();
        COSObject object = offset != null ? StaticResources.getDocument().getDocument().getObject(offset) : null;
        return object;
    }

    @Override
    public Boolean getXRefStreamHasTypeStream() {
        COSObject object = this.getXRefStreamValue();
        return GFAFileTrailer.getHasTypeStream(object);
    }

    @Override
    public Long getEncryptVIntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom("V"));
        return GFAFileTrailer.getIntegerValue(V);
    }

    @Override
    public Boolean getEncryptVHasTypeInteger() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom("V"));
        return GFAFileTrailer.getHasTypeInteger(V);
    }

    @Override
    public Boolean getcontainstrailerInfoModDate() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Info = trailer.getKey(ASAtom.getASAtom("Info"));
        return Info.knownKey(ASAtom.getASAtom("ModDate"));
    }

    @Override
    public Boolean getcontainstrailerCatalogPieceInfo() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Root = trailer.getKey(ASAtom.getASAtom("Root"));
        return Root.knownKey(ASAtom.getASAtom("PieceInfo"));
    }

    @Override
    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

