/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRequirementsHandlers;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARequirementsHandler;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ARequirementsglTF;
import org.verapdf.model.baselayer.Object;

public class GFARequirementsglTF
extends GFAObject
implements ARequirementsglTF {
    public GFARequirementsglTF(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARequirementsglTF");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "RH": {
                return this.getRH();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getRH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRH2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getRH2_0() {
        COSObject object = this.getRHValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRequirementsHandlers> list = new ArrayList<GFAArrayOfRequirementsHandlers>(1);
            list.add(new GFAArrayOfRequirementsHandlers((COSArray)object.getDirectBase(), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARequirementsHandler> list = new ArrayList<GFARequirementsHandler>(1);
            list.add(new GFARequirementsHandler((COSDictionary)object.getDirectBase(), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsPenalty() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Penalty"));
    }

    public COSObject getPenaltyDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return COSInteger.construct(100L);
            }
        }
        return null;
    }

    public COSObject getPenaltyValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Penalty"));
        if (object == null || object.empty()) {
            object = this.getPenaltyDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getPenaltyHasTypeInteger() {
        COSObject object = this.getPenaltyValue();
        return GFARequirementsglTF.getHasTypeInteger(object);
    }

    @Override
    public Long getPenaltyIntegerValue() {
        COSObject object = this.getPenaltyValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    @Override
    public Boolean getcontainsRH() {
        return this.baseObject.knownKey(ASAtom.getASAtom("RH"));
    }

    public COSObject getRHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("RH"));
        return object;
    }

    @Override
    public Boolean getRHHasTypeArray() {
        COSObject object = this.getRHValue();
        return GFARequirementsglTF.getHasTypeArray(object);
    }

    @Override
    public Boolean getRHHasTypeDictionary() {
        COSObject object = this.getRHValue();
        return GFARequirementsglTF.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("S"));
        return object;
    }

    @Override
    public Boolean getSHasTypeName() {
        COSObject object = this.getSValue();
        return GFARequirementsglTF.getHasTypeName(object);
    }

    @Override
    public String getSNameValue() {
        COSObject object = this.getSValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFARequirementsglTF.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public Boolean getVHasTypeName() {
        COSObject object = this.getVValue();
        return GFARequirementsglTF.getHasTypeName(object);
    }

    @Override
    public String getVNameValue() {
        COSObject object = this.getVValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }
}

