/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DViewAddEntries;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRichMediaConfiguration;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaContentNameTreeAssets;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf3DViewAddEntries;
import org.verapdf.model.alayer.AArrayOfRichMediaConfiguration;
import org.verapdf.model.alayer.ARichMediaContent;
import org.verapdf.model.alayer.ARichMediaContentNameTreeAssets;

public class GFARichMediaContent
extends GFAObject
implements ARichMediaContent {
    public GFARichMediaContent(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaContent");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Assets": {
                return this.getAssets();
            }
            case "Configurations": {
                return this.getConfigurations();
            }
            case "Views": {
                return this.getViews();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARichMediaContentNameTreeAssets> getAssets() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAssets1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaContentNameTreeAssets> getAssets1_7() {
        COSObject object = this.getAssetsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaContentNameTreeAssets> list = new ArrayList<GFARichMediaContentNameTreeAssets>(1);
            list.add(new GFARichMediaContentNameTreeAssets((COSDictionary)object.getDirectBase(), this.baseObject, "Assets"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaConfiguration> getConfigurations() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getConfigurations1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaConfiguration> getConfigurations1_7() {
        COSObject object = this.getConfigurationsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRichMediaConfiguration> list = new ArrayList<GFAArrayOfRichMediaConfiguration>(1);
            list.add(new GFAArrayOfRichMediaConfiguration((COSArray)object.getDirectBase(), this.baseObject, "Configurations"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DViewAddEntries> getViews() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getViews1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DViewAddEntries> getViews1_7() {
        COSObject object = this.getViewsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DViewAddEntries> list = new ArrayList<GFAArrayOf3DViewAddEntries>(1);
            list.add(new GFAArrayOf3DViewAddEntries((COSArray)object.getDirectBase(), this.baseObject, "Views"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAssets() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Assets"));
    }

    public COSObject getAssetsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Assets"));
        return object;
    }

    @Override
    public Boolean getAssetsHasTypeNameTree() {
        COSObject object = this.getAssetsValue();
        return GFARichMediaContent.getHasTypeNameTree(object);
    }

    @Override
    public Boolean getcontainsConfigurations() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Configurations"));
    }

    public COSObject getConfigurationsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Configurations"));
        return object;
    }

    @Override
    public Boolean getConfigurationsHasTypeArray() {
        COSObject object = this.getConfigurationsValue();
        return GFARichMediaContent.getHasTypeArray(object);
    }

    @Override
    public Long getConfigurationsArraySize() {
        COSObject object = this.getConfigurationsValue();
        return GFARichMediaContent.getArraySize(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFARichMediaContent.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsViews() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Views"));
    }

    public COSObject getViewsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Views"));
        return object;
    }

    @Override
    public Boolean getViewsHasTypeArray() {
        COSObject object = this.getViewsValue();
        return GFARichMediaContent.getHasTypeArray(object);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

