/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFA3DRenderMode;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DTransMatrix;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaInstance;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DNode;
import org.verapdf.model.alayer.A3DRenderMode;
import org.verapdf.model.alayer.AArrayOf3DTransMatrix;
import org.verapdf.model.alayer.ARichMediaInstance;
import org.verapdf.model.alayer.AStream;

public class GFA3DNode
extends GFAObject
implements A3DNode {
    public GFA3DNode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DNode");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Data": {
                return this.getData();
            }
            case "Instance": {
                return this.getInstance();
            }
            case "M": {
                return this.getM();
            }
            case "RM": {
                return this.getRM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getData2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getData2_0() {
        COSObject object = this.getDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaInstance> getInstance() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getInstance2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaInstance> getInstance2_0() {
        COSObject object = this.getInstanceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaInstance> list = new ArrayList<GFARichMediaInstance>(1);
            list.add(new GFARichMediaInstance((COSDictionary)object.getDirectBase(), this.baseObject, "Instance"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getM() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_7: {
                return this.getM1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getM1_7() {
        COSObject object = this.getMValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DTransMatrix> list = new ArrayList<GFAArrayOf3DTransMatrix>(1);
            list.add(new GFAArrayOf3DTransMatrix((COSArray)object.getDirectBase(), this.baseObject, "M"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A3DRenderMode> getRM() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRM2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DRenderMode> getRM2_0() {
        COSObject object = this.getRMValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DRenderMode> list = new ArrayList<GFA3DRenderMode>(1);
            list.add(new GFA3DRenderMode((COSDictionary)object.getDirectBase(), this.baseObject, "RM"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsData() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Data"));
    }

    public COSObject getDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Data"));
        return object;
    }

    @Override
    public Boolean getisDataIndirect() {
        COSObject object = this.getDataValue();
        return GFA3DNode.getisIndirect(object);
    }

    @Override
    public Boolean getDataHasTypeStream() {
        COSObject object = this.getDataValue();
        return GFA3DNode.getHasTypeStream(object);
    }

    @Override
    public Boolean getDataHasTypeStringText() {
        COSObject object = this.getDataValue();
        return GFA3DNode.getHasTypeStringText(object);
    }

    @Override
    public Boolean getcontainsInstance() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Instance"));
    }

    public COSObject getInstanceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Instance"));
        return object;
    }

    @Override
    public Boolean getInstanceHasTypeDictionary() {
        COSObject object = this.getInstanceValue();
        return GFA3DNode.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsM() {
        return this.baseObject.knownKey(ASAtom.getASAtom("M"));
    }

    public COSObject getMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("M"));
        return object;
    }

    @Override
    public Boolean getMHasTypeArray() {
        COSObject object = this.getMValue();
        return GFA3DNode.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsN() {
        return this.baseObject.knownKey(ASAtom.getASAtom("N"));
    }

    public COSObject getNValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("N"));
        return object;
    }

    @Override
    public Boolean getNHasTypeString() {
        COSObject object = this.getNValue();
        return GFA3DNode.getHasTypeString(object);
    }

    @Override
    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom("O"));
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("O"));
        return object;
    }

    @Override
    public Boolean getOHasTypeNumber() {
        COSObject object = this.getOValue();
        return GFA3DNode.getHasTypeNumber(object);
    }

    @Override
    public Double getONumberValue() {
        COSObject object = this.getOValue();
        return GFA3DNode.getNumberValue(object);
    }

    @Override
    public Boolean getcontainsRM() {
        return this.baseObject.knownKey(ASAtom.getASAtom("RM"));
    }

    public COSObject getRMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("RM"));
        return object;
    }

    @Override
    public Boolean getRMHasTypeDictionary() {
        COSObject object = this.getRMValue();
        return GFA3DNode.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFA3DNode.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFA3DNode.getNameValue(object);
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public Boolean getVHasTypeBoolean() {
        COSObject object = this.getVValue();
        return GFA3DNode.getHasTypeBoolean(object);
    }
}

