/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.CIDWArray;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDCIDSystemInfo;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cff.CFFType1FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.CIDFontType2Program;
import org.verapdf.tools.FontProgramIDGenerator;
import org.verapdf.tools.StaticResources;

public class PDCIDFont
extends PDFont {
    private static final Logger LOGGER = Logger.getLogger(PDCIDFont.class.getCanonicalName());
    private static final Double DEFAULT_CID_FONT_WIDTH = 1000.0;
    protected CMap cMap;
    private CIDWArray widths;
    private PDCIDSystemInfo cidSystemInfo;

    public PDCIDFont(COSDictionary dictionary, CMap cMap) {
        super(dictionary);
        this.cMap = cMap;
    }

    public PDCIDFont(COSDictionary dictionary, CMap cMap, FontProgram fontProgram, boolean isFontParsed) {
        this(dictionary, cMap);
        this.fontProgram = fontProgram;
        this.isFontParsed = isFontParsed;
        if (fontProgram != null) {
            this.isFontParsed = true;
        }
    }

    protected PDCIDFont(COSDictionary dictionary) {
        super(dictionary);
    }

    public COSStream getCIDSet() {
        COSObject cidSet;
        if (this.fontDescriptor != null && (cidSet = this.fontDescriptor.getKey(ASAtom.CID_SET)) != null && cidSet.getType() == COSObjType.COS_STREAM) {
            return (COSStream)cidSet.getDirectBase();
        }
        return null;
    }

    public COSObject getCIDToGIDMap() {
        return this.dictionary.getKey(ASAtom.CID_TO_GID_MAP);
    }

    @Override
    public Double getWidth(int code) {
        Double res;
        if (this.widths == null) {
            COSObject w = this.dictionary.getKey(ASAtom.W);
            if (w.empty() || w.getType() != COSObjType.COS_ARRAY) {
                return this.getDefaultWidth();
            }
            this.widths = new CIDWArray((COSArray)w.getDirectBase());
        }
        if ((res = this.widths.getWidth(this.cMap.toCID(code))) == null) {
            res = this.getDefaultWidth();
        }
        return res;
    }

    @Override
    public Double getDefaultWidth() {
        COSObject dw = this.dictionary.getKey(ASAtom.DW);
        if (dw.getType().isNumber()) {
            return dw.getReal();
        }
        return DEFAULT_CID_FONT_WIDTH;
    }

    @Override
    public int readCode(InputStream stream) throws IOException {
        if (this.cMap != null) {
            return this.cMap.getCodeFromStream(stream);
        }
        throw new IOException("No CMap for Type 0 font " + (this.getName() == null ? "" : this.getName()));
    }

    @Override
    public FontProgram getFontProgram() {
        block30: {
            if (!this.isFontParsed) {
                this.isFontParsed = true;
                if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE2) && this.getSubtype() == ASAtom.CID_FONT_TYPE2) {
                    COSStream trueTypeFontFile = this.fontDescriptor.getFontFile2();
                    COSKey key = trueTypeFontFile.getObjectKey();
                    COSObject cidToGIDMap = this.getCIDToGIDMap();
                    String fontProgramID = FontProgramIDGenerator.getCIDFontType2ProgramID(key, this.cMap, cidToGIDMap);
                    this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                    if (this.fontProgram == null) {
                        try (ASInputStream fontData = trueTypeFontFile.getData(COSStream.FilterFlags.DECODE);){
                            this.fontProgram = new CIDFontType2Program(fontData, this.cMap, cidToGIDMap);
                            StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINE, "Can't read TrueType font program.", e);
                        }
                    }
                } else if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3)) {
                    COSStream fontFile = this.fontDescriptor.getFontFile3();
                    COSName subtype = (COSName)fontFile.getKey(ASAtom.SUBTYPE).getDirectBase();
                    COSKey key = fontFile.getObjectKey();
                    try {
                        boolean isSubset = this.isSubset();
                        if (ASAtom.CID_FONT_TYPE0C == subtype.getName()) {
                            String fontProgramID = FontProgramIDGenerator.getCFFFontProgramID(key, this.cMap, isSubset);
                            this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                            if (this.fontProgram != null) break block30;
                            try (ASInputStream fontData = fontFile.getData(COSStream.FilterFlags.DECODE);){
                                this.fontProgram = new CFFFontProgram(fontData, this.cMap, isSubset);
                                StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                                break block30;
                            }
                        }
                        if (ASAtom.OPEN_TYPE == subtype.getName()) {
                            ASAtom fontName = ASAtom.getASAtom(this.getName());
                            boolean isCFF = fontName != ASAtom.TRUE_TYPE && fontName != ASAtom.CID_FONT_TYPE2;
                            boolean isSymbolic = this.isSymbolic();
                            COSObject encoding = this.getEncoding();
                            String fontProgramID = FontProgramIDGenerator.getOpenTypeFontProgramID(key, isCFF, isSymbolic, encoding, this.cMap, isSubset);
                            this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                            if (this.fontProgram != null) break block30;
                            try (ASInputStream fontData = fontFile.getData(COSStream.FilterFlags.DECODE);){
                                this.fontProgram = new OpenTypeFontProgram(fontData, isCFF, isSymbolic, encoding, this.cMap, isSubset);
                                StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                                break block30;
                            }
                        }
                        LOGGER.warning("Invalid subtype of the embedded font stream");
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Can't read font program.", e);
                    }
                } else {
                    this.fontProgram = null;
                }
            }
        }
        return this.fontProgram;
    }

    @Override
    public float getWidthFromProgram(int code) {
        int cid = this.cMap.toCID(code);
        FontProgram font = this.getFontProgram();
        CFFType1FontProgram cffType1 = CFFType1FontProgram.getCFFType1(font);
        if (cid != 0 && cffType1 != null) {
            return cffType1.getWidthFromGID(cid);
        }
        return font.getWidth(code);
    }

    @Override
    public boolean glyphIsPresent(int code) {
        int cid = this.cMap.toCID(code);
        FontProgram font = this.getFontProgram();
        CFFType1FontProgram cffType1 = CFFType1FontProgram.getCFFType1(font);
        if (cid != 0 && cffType1 != null) {
            return cffType1.containsGID(cid);
        }
        return font.containsCode(code);
    }

    public PDCIDSystemInfo getCIDSystemInfo() {
        if (this.cidSystemInfo != null) {
            return this.cidSystemInfo;
        }
        this.cidSystemInfo = new PDCIDSystemInfo(this.dictionary.getKey(ASAtom.CID_SYSTEM_INFO));
        return this.cidSystemInfo;
    }
}

