/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.processor.AbstractBatchHandler;

public abstract class AbstractXmlHandler
extends AbstractBatchHandler {
    private static final Logger logger = Logger.getLogger(AbstractXmlHandler.class.getCanonicalName());
    protected static final String strmExcpMessTmpl = "XmlStreamException caught when %s output writer.";
    protected static final String unmarshalErrMessage = "Unmarshalling exception when streaming %s.";
    protected static final String writingMessage = "writing";
    private static final String encoding = "utf-8";
    private static final String xmlVersion = "1.0";
    private static final String lineSepProp = "line.separator";
    private static final String newline = System.getProperty("line.separator");
    private static XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
    protected XMLStreamWriter writer;

    protected AbstractXmlHandler(Writer dest) throws VeraPDFException {
        try {
            this.writer = new IndentingXMLStreamWriter(outputFactory.createXMLStreamWriter(dest));
        }
        catch (XMLStreamException excep) {
            throw AbstractXmlHandler.wrapStreamException(excep, "initialising");
        }
    }

    protected <T> void serializeElement(T obj, String eleName, boolean format, boolean fragment) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(obj, this.writer, format, fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format(unmarshalErrMessage, eleName), excep);
            throw AbstractXmlHandler.wrapMarshallException(excep, eleName);
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format(strmExcpMessTmpl, writingMessage), excep);
            throw AbstractXmlHandler.wrapStreamException(excep, eleName);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (XMLStreamException excep) {
            logger.log(Level.INFO, String.format(strmExcpMessTmpl, "closing"), excep);
        }
    }

    protected static void startDoc(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument(encoding, xmlVersion);
    }

    protected static void endDoc(XMLStreamWriter writer) throws XMLStreamException {
        AbstractXmlHandler.newLine(writer);
        writer.writeEndDocument();
    }

    protected void addAttribute(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name, value);
    }

    protected static void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(newline);
    }

    protected static VeraPDFException wrapStreamException(XMLStreamException excep) {
        return AbstractXmlHandler.wrapStreamException(excep, "writing to");
    }

    protected static VeraPDFException wrapStreamException(XMLStreamException excep, String verbPart) {
        return new VeraPDFException(String.format(strmExcpMessTmpl, verbPart), excep);
    }

    protected static final VeraPDFException wrapMarshallException(JAXBException excep, String typePart) {
        return new VeraPDFException(String.format(unmarshalErrMessage, typePart), excep);
    }
}

