/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf_3RGBNumbers;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DBackground;
import org.verapdf.model.alayer.AArrayOf_3RGBNumbers;
import org.verapdf.model.baselayer.Object;

public class GFA3DBackground
extends GFAObject
implements A3DBackground {
    public GFA3DBackground(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DBackground");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "C": {
                return this.getC();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOf_3RGBNumbers> getC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getC1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_3RGBNumbers> getC1_6() {
        COSObject object = this.getCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_3RGBNumbers> list = new ArrayList<GFAArrayOf_3RGBNumbers>(1);
            list.add(new GFAArrayOf_3RGBNumbers((COSArray)object.getDirectBase(), this.baseObject, "C"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("C"));
    }

    public COSObject getCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("C"));
        return object;
    }

    @Override
    public Boolean getCHasTypeArray() {
        COSObject object = this.getCValue();
        return GFA3DBackground.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsCS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CS"));
    }

    public COSObject getCSDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("DeviceRGB");
            }
        }
        return null;
    }

    public COSObject getCSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CS"));
        if (object == null || object.empty()) {
            object = this.getCSDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getCSHasTypeName() {
        COSObject object = this.getCSValue();
        return GFA3DBackground.getHasTypeName(object);
    }

    @Override
    public String getCSNameValue() {
        COSObject object = this.getCSValue();
        return GFA3DBackground.getNameValue(object);
    }

    @Override
    public Boolean getcontainsEA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EA"));
    }

    public COSObject getEADefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(false);
            }
        }
        return null;
    }

    public COSObject getEAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EA"));
        if (object == null || object.empty()) {
            object = this.getEADefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getEAHasTypeBoolean() {
        COSObject object = this.getEAValue();
        return GFA3DBackground.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("SC");
            }
        }
        return null;
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        if (object == null || object.empty()) {
            object = this.getSubtypeDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.getSubtypeValue();
        return GFA3DBackground.getHasTypeName(object);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject object = this.getSubtypeValue();
        return GFA3DBackground.getNameValue(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFA3DBackground.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFA3DBackground.getNameValue(object);
    }
}

