/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;

public class PDInlineImage
extends PDResource {
    private static Map<ASAtom, ASAtom> abbreviationsMap = new HashMap<ASAtom, ASAtom>();
    private static Map<ASAtom, ASAtom> abbreviationsFiltersAndColorSpaceMap = new HashMap<ASAtom, ASAtom>();
    private static final Logger LOGGER = Logger.getLogger(PDInlineImage.class.getCanonicalName());
    private PDResources imageResources;
    private PDResources pageResources;

    public PDInlineImage(COSObject obj, PDResources imageResources, PDResources pageResources) {
        super(obj);
        this.imageResources = imageResources;
        this.pageResources = pageResources;
    }

    public boolean isInterpolate() {
        COSObject interpolate = PDInlineImage.getInlineImageKey(this.getObject().get(), ASAtom.INTERPOLATE);
        Boolean result = interpolate.getBoolean();
        return result != null ? result : false;
    }

    public Long getBitsPerComponent() {
        COSObject bitsPerComponent = PDInlineImage.getInlineImageKey(this.getObject().get(), ASAtom.BITS_PER_COMPONENT);
        return bitsPerComponent.getInteger();
    }

    public List<COSName> getCOSFilters() {
        COSObject filters = PDInlineImage.getInlineImageKey(this.getObject().get(), ASAtom.FILTER);
        if (filters != null) {
            ArrayList<COSName> res = new ArrayList<COSName>();
            if (filters.getType() == COSObjType.COS_NAME) {
                res.add((COSName)filters.getDirectBase());
            } else if (filters.getType() == COSObjType.COS_ARRAY) {
                for (COSObject filter : (COSArray)filters.getDirectBase()) {
                    if (filter == null || filter.getType() != COSObjType.COS_NAME) {
                        LOGGER.log(Level.FINE, "Filter array contains non name value");
                        return Collections.emptyList();
                    }
                    res.add((COSName)filter.getDirectBase());
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public PDColorSpace getImageCS() {
        PDColorSpace result;
        COSObject cs = PDInlineImage.getInlineImageKey(this.getObject().get(), ASAtom.COLORSPACE);
        if (cs != null && cs.getType() == COSObjType.COS_NAME) {
            PDInlineImage.replaceAbbreviation((COSName)cs.getDirectBase());
            result = this.getDefaultColorSpace(cs.getName());
            if (result != null) {
                return result;
            }
        }
        if ((result = ColorSpaceFactory.getColorSpace(cs, this.imageResources)) == null) {
            result = ColorSpaceFactory.getColorSpace(cs, this.pageResources);
        }
        return result;
    }

    public boolean getImageMask() {
        COSObject im = PDInlineImage.getInlineImageKey(this.getObject().get(), ASAtom.IMAGE_MASK);
        Boolean result = im.getBoolean();
        return result != null ? result : false;
    }

    public static COSObject getInlineImageKey(COSBase inlineImage, ASAtom key) {
        if (inlineImage == null) {
            return COSObject.getEmpty();
        }
        ASAtom abbreviation = abbreviationsMap.get(key);
        return abbreviation != null && inlineImage.knownKey(abbreviation) != false ? inlineImage.getKey(abbreviation) : inlineImage.getKey(key);
    }

    private PDColorSpace getDefaultColorSpace(ASAtom name) {
        if (PDInlineImage.isDeviceDependent(name)) {
            if (this.imageResources != null) {
                ASAtom value = ColorSpaceFactory.getDefaultValue(this.imageResources, name);
                if (value != null) {
                    return this.imageResources.getColorSpace(value);
                }
            } else {
                ASAtom value = ColorSpaceFactory.getDefaultValue(this.pageResources, name);
                if (value != null) {
                    return this.pageResources.getColorSpace(value);
                }
            }
        }
        return null;
    }

    private static boolean isDeviceDependent(ASAtom name) {
        return ASAtom.DEVICERGB.equals(name) || ASAtom.DEVICEGRAY.equals(name) || ASAtom.DEVICECMYK.equals(name);
    }

    public static void replaceAbbreviation(COSName abbreviation) {
        ASAtom name = abbreviationsFiltersAndColorSpaceMap.get(abbreviation.getName());
        if (name != null) {
            abbreviation.set(name);
        }
    }

    public COSName getIntent() {
        COSObject object = this.getKey(ASAtom.INTENT);
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return (COSName)object.getDirectBase();
        }
        return null;
    }

    static {
        abbreviationsMap.put(ASAtom.BITS_PER_COMPONENT, ASAtom.BPC);
        abbreviationsMap.put(ASAtom.COLORSPACE, ASAtom.CS);
        abbreviationsMap.put(ASAtom.DECODE, ASAtom.D);
        abbreviationsMap.put(ASAtom.DECODE_PARMS, ASAtom.DP);
        abbreviationsMap.put(ASAtom.FILTER, ASAtom.F);
        abbreviationsMap.put(ASAtom.HEIGHT, ASAtom.H);
        abbreviationsMap.put(ASAtom.IMAGE_MASK, ASAtom.IM);
        abbreviationsMap.put(ASAtom.INTERPOLATE, ASAtom.I);
        abbreviationsMap.put(ASAtom.LENGTH, ASAtom.L);
        abbreviationsMap.put(ASAtom.WIDTH, ASAtom.W);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.G, ASAtom.DEVICEGRAY);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.RGB, ASAtom.DEVICERGB);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.CMYK, ASAtom.DEVICECMYK);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.I, ASAtom.INDEXED);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.ASCII_HEX_DECODE_ABBREVIATION, ASAtom.ASCII_HEX_DECODE);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.ASCII85_DECODE_ABBREVIATION, ASAtom.ASCII85_DECODE);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.LZW_DECODE_ABBREVIATION, ASAtom.LZW_DECODE);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.FLATE_DECODE_ABBREVIATION, ASAtom.FLATE_DECODE);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.RUN_LENGTH_DECODE_ABBREVIATION, ASAtom.RUN_LENGTH_DECODE);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.CCITTFAX_DECODE_ABBREVIATION, ASAtom.CCITTFAX_DECODE);
        abbreviationsFiltersAndColorSpaceMap.put(ASAtom.DCT_DECODE_ABBREVIATION, ASAtom.DCT_DECODE);
    }
}

