/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosActualText;
import org.verapdf.gf.model.impl.cos.GFCosAlt;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDStructTreeNode;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosAlt;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;

public class GFPDStructElem
extends GFPDStructTreeNode
implements org.verapdf.model.pdlayer.PDStructElem {
    private static final Logger LOGGER = Logger.getLogger(GFPDStructElem.class.getCanonicalName());
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";
    public static final String ACTUAL_TEXT = "actualText";
    public static final String ALT = "alt";
    private final String standardType;

    protected GFPDStructElem(PDStructElem structElemDictionary, String standardType, String type) {
        super(structElemDictionary, type);
        ASAtom subtype = this.simplePDObject.getNameKey(ASAtom.S);
        if (subtype != null) {
            this.id = (super.getID() != null ? super.getID() : "0 0 obj") + ' ' + ((COSName)COSName.fromValue(subtype)).getUnicodeValue();
        }
        this.standardType = standardType;
        if (PDFFlavours.isPDFUA2RelatedFlavour(StaticContainers.getFlavour())) {
            this.fillStructElemRefs();
        }
    }

    public GFPDStructElem(PDStructElem structElemDictionary) {
        this(structElemDictionary, null, STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public String getparentStandardType() {
        PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent();
        if (parent != null) {
            String parentStandardType;
            StructureType parentStandardStructureType = PDStructElem.getStructureElementStandardStructureType(parent);
            String string = parentStandardType = parentStandardStructureType != null ? parentStandardStructureType.getType().getValue() : null;
            while ("NonStruct".equals(parentStandardType) || "Div".equals(parentStandardType)) {
                if ((parent = parent.getParent()) == null) {
                    return null;
                }
                parentStandardStructureType = PDStructElem.getStructureElementStandardStructureType(parent);
                parentStandardType = parentStandardStructureType != null ? parentStandardStructureType.getType().getValue() : null;
            }
            if (parent.getType() == ASAtom.STRUCT_TREE_ROOT) {
                return ASAtom.STRUCT_TREE_ROOT.getValue();
            }
            if (PDStructElem.isMathStandardType(parentStandardStructureType)) {
                return "MathML";
            }
            return parentStandardType;
        }
        return null;
    }

    @Override
    public String getnamespaceAndTag() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        if (type != null) {
            return String.format("%s:%s", type.getNameSpaceURI() != null ? type.getNameSpaceURI() : "null", type.getType() != null ? type.getType() : "null");
        }
        return null;
    }

    @Override
    public Boolean getcontainsParent() {
        return ((PDStructElem)this.simplePDObject).getParent() != null;
    }

    @Override
    public String getvalueS() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        return type != null ? type.getString() : null;
    }

    @Override
    public String getstandardType() {
        return this.standardType;
    }

    public String getStandardTypeNamespaceURL() {
        StructureType standardStructureType = PDStructElem.getStructureElementStandardStructureType((PDStructElem)this.simplePDObject);
        return standardStructureType != null ? standardStructureType.getNameSpaceURI() : null;
    }

    @Override
    public String getremappedStandardType() {
        StructureType standardTypeMap;
        StructureType standardStructureType = PDStructElem.getStructureElementStandardStructureType((PDStructElem)this.simplePDObject);
        if (this.hasStandardType()) {
            StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
            if (type == null) {
                return null;
            }
            if (!Objects.equals(type.getType(), standardStructureType.getType()) || !Objects.equals(type.getNameSpaceURI(), standardStructureType.getNameSpaceURI())) {
                return type.getType().getValue();
            }
        } else if (!(this.standardType == null || Objects.equals((standardTypeMap = PDStructElem.getStructureTypeStandardStructureType(standardStructureType)).getType(), standardStructureType.getType()) && Objects.equals(standardTypeMap.getNameSpaceURI(), standardStructureType.getNameSpaceURI()))) {
            return this.standardType;
        }
        return null;
    }

    private boolean hasStandardType() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        if (type == null) {
            return false;
        }
        if (PDFFlavours.isWCAGFlavour(StaticContainers.getFlavour()) && ASAtom.TITLE == type.getType()) {
            return false;
        }
        return PDStructElem.isStandardStructureType(type);
    }

    @Override
    public String getAlt() {
        return ((PDStructElem)this.simplePDObject).getAlternateDescription();
    }

    @Override
    public String getActualText() {
        return ((PDStructElem)this.simplePDObject).getActualText().getString();
    }

    @Override
    public String getE() {
        return ((PDStructElem)this.simplePDObject).getExpandedAbbreviation();
    }

    @Override
    public Boolean getcircularMappingExist() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        if (type != null) {
            if (StaticResources.getRoleMapHelper().circularMappingExist(type.getType()).booleanValue()) {
                return true;
            }
            if (PDFFlavours.isPDFSpecification(StaticContainers.getFlavour(), PDFAFlavour.PDFSpecification.ISO_32000_2_0) && TaggedPDFHelper.isCircularMappingExist(type).booleanValue()) {
                return true;
            }
            return false;
        }
        return null;
    }

    @Override
    public String getroleMapToSameNamespaceTag() {
        return ((PDStructElem)this.simplePDObject).getRoleMapToSameNamespaceTag();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
            case "actualText": {
                return this.getactualText();
            }
            case "alt": {
                return this.getalt();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public String getparentLang() {
        HashSet<COSKey> keys = new HashSet<COSKey>();
        COSKey key = this.simplePDObject.getObject().getObjectKey();
        if (key != null) {
            keys.add(key);
        }
        COSString baseLang = null;
        for (PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent(); baseLang == null && parent != null; parent = parent.getParent()) {
            key = parent.getObject().getObjectKey();
            if (keys.contains(key)) {
                LOGGER.log(Level.WARNING, "Struct tree loop found");
                break;
            }
            if (key != null) {
                keys.add(key);
            }
            baseLang = parent.getLang();
        }
        if (baseLang != null) {
            return baseLang.getString();
        }
        return null;
    }

    private List<CosActualText> getactualText() {
        COSObject actualText = ((PDStructElem)this.simplePDObject).getActualText();
        if (actualText != null && COSObjType.COS_STRING == actualText.getType()) {
            ArrayList<CosActualText> list = new ArrayList<CosActualText>(1);
            list.add(new GFCosActualText((COSString)actualText.getDirectBase()));
            return list;
        }
        return Collections.emptyList();
    }

    private void fillStructElemRefs() {
        COSKey key = this.simpleCOSObject.getKey();
        if (key == null) {
            return;
        }
        COSObject ref = ((PDStructElem)this.simplePDObject).getRef();
        if (ref.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)ref.getDirectBase()) {
                if (elem.getKey() == null) continue;
                StaticContainers.getStructElementsRefs().computeIfAbsent(elem.getKey(), k -> new HashSet()).add(key);
            }
        }
    }

    private List<CosAlt> getalt() {
        COSObject alt = this.simplePDObject.getKey(ASAtom.ALT);
        if (alt != null && COSObjType.COS_STRING == alt.getType()) {
            ArrayList<CosAlt> list = new ArrayList<CosAlt>(1);
            list.add(new GFCosAlt((COSString)alt.getDirectBase()));
            return list;
        }
        return Collections.emptyList();
    }
}

