/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEGroupedContent;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEMarkedContent;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEUnmarkedContent;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDSemanticContentStream;
import org.verapdf.model.selayer.SEContentItem;
import org.verapdf.pd.PDContentStream;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFPDSemanticContentStream
extends GFPDContentStream
implements PDSemanticContentStream {
    public static final String CONTENT = "content";
    public static final String SEMANTIC_CONTENT_STREAM_TYPE = "PDSemanticContentStream";
    private String defaultLang;
    private boolean isSignature = false;

    public GFPDSemanticContentStream(PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, COSKey parentObjectKey) {
        super(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, parentObjectKey, SEMANTIC_CONTENT_STREAM_TYPE);
    }

    public GFPDSemanticContentStream(PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, COSObject parentStructElem, List<String> parentsTags, COSKey parentObjectKey) {
        super(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, parentStructElem, parentsTags, parentObjectKey, SEMANTIC_CONTENT_STREAM_TYPE);
    }

    public GFPDSemanticContentStream(PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, COSObject parentStructElem, List<String> parentsTags, String defaultLang, boolean isSignature, COSKey parentObjectKey) {
        this(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, parentStructElem, parentsTags, parentObjectKey);
        this.defaultLang = defaultLang;
        this.isSignature = isSignature;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "content": {
                return this.getContentItem();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<SEContentItem> getContentItem() {
        if (this.operators == null) {
            this.parseOperators();
        }
        int unmarkedContentIndex = 0;
        int markedContentIndex = -1;
        Stack<Integer> markedContentStack = new Stack<Integer>();
        ArrayList<GFSEGroupedContent> list = new ArrayList<GFSEGroupedContent>();
        for (int i = 0; i < this.operators.size(); ++i) {
            String type = ((Operator)this.operators.get(i)).getObjectType();
            if ("Op_BDC".equals(type) || "Op_BMC".equals(type)) {
                if (markedContentStack.empty() && i != markedContentIndex + 1) {
                    list.add(new GFSEUnmarkedContent(this.operators.subList(unmarkedContentIndex, i), this.parentStructElem, this.parentsTags, this.defaultLang, this.isSignature));
                }
                markedContentStack.push(i);
                continue;
            }
            if (!"Op_EMC".equals(type) || markedContentStack.empty()) continue;
            markedContentIndex = (Integer)markedContentStack.pop();
            if (!markedContentStack.empty()) continue;
            list.add(new GFSEMarkedContent((GFOpMarkedContent)this.operators.get(markedContentIndex), this.operators.subList(markedContentIndex + 1, i + 1), this.parentStructElem, (List<String>)this.parentsTags, this.defaultLang, this.isSignature));
            markedContentIndex = i;
            unmarkedContentIndex = i + 1;
        }
        if (unmarkedContentIndex != this.operators.size()) {
            list.add(new GFSEUnmarkedContent(this.operators.subList(unmarkedContentIndex, this.operators.size()), this.parentStructElem, this.parentsTags, this.defaultLang, this.isSignature));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    protected boolean isSemantic() {
        return true;
    }
}

