/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.validation.profiles.ErrorArgument;
import org.verapdf.pdfa.validation.profiles.ErrorDetails;
import org.verapdf.pdfa.validation.profiles.RuleImpl;

@XmlRootElement(name="error")
final class ErrorDetailsImpl
implements ErrorDetails {
    private static final ErrorDetailsImpl DEFAULT = new ErrorDetailsImpl();
    @XmlElement
    private final String message;
    @XmlElementWrapper
    @XmlElement(name="argument")
    private final List<ErrorArgument> arguments;

    private ErrorDetailsImpl() {
        this("message", Collections.emptyList());
    }

    private ErrorDetailsImpl(String message, List<ErrorArgument> arguments) {
        this.message = message;
        this.arguments = new ArrayList<ErrorArgument>(arguments);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<ErrorArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public final int hashCode() {
        int prime = 31;
        int result = this.arguments == null ? 0 : this.arguments.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetails)) {
            return false;
        }
        ErrorDetails other = (ErrorDetails)obj;
        if (!Objects.equals(this.arguments, other.getArguments())) {
            return false;
        }
        return Objects.equals(this.message, other.getMessage());
    }

    public String toString() {
        return "ErrorDetails [message=" + this.message + ", arguments=" + this.arguments + "]";
    }

    static ErrorDetailsImpl defaultInstance() {
        return DEFAULT;
    }

    static ErrorDetailsImpl fromValues(String message, List<ErrorArgument> arguments) {
        return new ErrorDetailsImpl(message, arguments);
    }

    static class Adapter
    extends XmlAdapter<ErrorDetailsImpl, ErrorDetails> {
        Adapter() {
        }

        @Override
        public ErrorDetailsImpl unmarshal(ErrorDetailsImpl errorDetailsImpl) {
            return new ErrorDetailsImpl(RuleImpl.getStringWithoutProfilesTabulation(errorDetailsImpl.getMessage()), errorDetailsImpl.getArguments());
        }

        @Override
        public ErrorDetailsImpl marshal(ErrorDetails errorDetails) {
            return (ErrorDetailsImpl)errorDetails;
        }
    }
}

