/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser.postscript;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.parser.postscript.PSObject;
import org.verapdf.parser.postscript.PSProcedure;
import org.verapdf.parser.postscript.PSStackMark;
import org.verapdf.parser.postscript.PostScriptException;

public class PSOperator
extends PSObject {
    private Stack<COSObject> operandStack;
    private Map<ASAtom, COSObject> userDict;
    private String operator;

    public PSOperator(COSName operator) {
        super(operator);
        this.operator = operator.getString();
    }

    @Override
    public void execute(Stack<COSObject> operandStack, Map<ASAtom, COSObject> userDict) throws PostScriptException {
        this.operandStack = operandStack;
        this.userDict = userDict;
        if (this.operator != null) {
            switch (this.operator) {
                case "dup": {
                    operandStack.push(PSOperator.psCopyObject(operandStack.peek()));
                    break;
                }
                case "exch": {
                    COSObject obj1 = operandStack.pop();
                    COSObject obj2 = operandStack.pop();
                    operandStack.push(obj1);
                    operandStack.push(obj2);
                    break;
                }
                case "pop": {
                    operandStack.pop();
                    break;
                }
                case "copy": {
                    this.copy();
                    break;
                }
                case "index": {
                    this.index();
                    break;
                }
                case "roll": {
                    this.roll();
                    break;
                }
                case "clear": {
                    this.operandStack.clear();
                    break;
                }
                case "count": {
                    COSObject stackSize = COSInteger.construct(this.operandStack.size());
                    this.operandStack.push(stackSize);
                    break;
                }
                case "mark": {
                    this.operandStack.push(PSStackMark.getInstance());
                    break;
                }
                case "cleartomark": {
                    COSObject topObject = this.operandStack.peek();
                    while (!operandStack.empty() && topObject != PSStackMark.getInstance()) {
                        operandStack.pop();
                        topObject = this.operandStack.peek();
                    }
                    break;
                }
                case "counttomark": {
                    this.counttomark();
                    break;
                }
                case "add": 
                case "div": 
                case "idiv": 
                case "mod": 
                case "mul": 
                case "sub": {
                    this.executeOperatorOnTopTwoNumbers(this.operator);
                    break;
                }
                case "abs": 
                case "neg": 
                case "ceiling": 
                case "floor": 
                case "round": {
                    this.executeOperatorOnOneTopNumber(this.operator);
                    break;
                }
                case "dict": {
                    this.getTopNumber();
                    operandStack.push(COSDictionary.construct());
                    break;
                }
                case "begin": {
                    if (operandStack.size() <= 0) break;
                    operandStack.pop();
                    break;
                }
                case "length": {
                    this.length();
                    break;
                }
                case "def": {
                    this.def();
                    break;
                }
                case "load": {
                    this.load();
                    break;
                }
                case "array": {
                    this.array();
                    break;
                }
                case "put": {
                    this.put();
                    break;
                }
                case "for": {
                    this.opFor();
                    break;
                }
                default: {
                    COSObject dictEntry = userDict.get(ASAtom.getASAtom(this.operator));
                    if (dictEntry == null) break;
                    PSObject.getPSObject(dictEntry).execute(operandStack, userDict);
                }
            }
        }
    }

    private void copy() throws PostScriptException {
        try {
            ArrayList<COSObject> toAppend;
            COSObject n = this.getTopNumber();
            int size = this.operandStack.size();
            if ((long)size >= n.getInteger()) {
                List toCopy = this.operandStack.subList(size - n.getInteger().intValue(), size);
                toAppend = new ArrayList<COSObject>(toCopy.size());
                for (COSObject object : toCopy) {
                    toAppend.add(PSOperator.psCopyObject(object));
                }
            } else {
                throw new PostScriptException("Stack does not contain " + n.getInteger() + " elements to copy");
            }
            this.operandStack.addAll(toAppend);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute copy operator", e);
        }
    }

    private void index() throws PostScriptException {
        try {
            COSObject n = this.getTopNumber();
            if (this.operandStack.size() < n.getInteger().intValue()) {
                throw new PostScriptException("Stack does not contain " + n.getInteger() + " elements");
            }
            COSObject toCopy = (COSObject)this.operandStack.get(this.operandStack.size() - n.getInteger().intValue() - 1);
            this.operandStack.push(PSOperator.psCopyObject(toCopy));
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute index operator", e);
        }
    }

    private void roll() throws PostScriptException {
        try {
            COSObject[] topTwoNumbers = this.getTopTwoNumbers();
            int j = topTwoNumbers[0].getInteger().intValue();
            int n = topTwoNumbers[1].getInteger().intValue();
            int size = this.operandStack.size();
            if (size < n) {
                throw new PostScriptException("Stack has less than n elements");
            }
            List lastElements = this.operandStack.subList(size - n, size);
            int splitPoint = n - 1 - (j - 1) % n;
            this.operandStack.addAll(lastElements.subList(splitPoint - 1, size));
            this.operandStack.addAll(lastElements.subList(0, splitPoint - 1));
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute roll operator", e);
        }
    }

    private void counttomark() {
        long res = 0L;
        for (int i = this.operandStack.size() - 1; i >= 0; --i) {
            if (this.operandStack.get(i) == PSStackMark.getInstance() || i == 0) {
                this.operandStack.push(COSInteger.construct(res));
                return;
            }
            ++res;
        }
    }

    private void executeOperatorOnTopTwoNumbers(String operator) throws PostScriptException {
        try {
            COSObject res;
            COSObject[] topTwoNumbers = this.getTopTwoNumbers();
            switch (operator) {
                case "add": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() + topTwoNumbers[0].getReal());
                    break;
                }
                case "div": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() / topTwoNumbers[0].getReal());
                    break;
                }
                case "idiv": {
                    res = COSInteger.construct(topTwoNumbers[1].getInteger() / topTwoNumbers[0].getInteger());
                    break;
                }
                case "mod": {
                    res = COSInteger.construct(topTwoNumbers[1].getInteger() % topTwoNumbers[0].getInteger());
                    break;
                }
                case "mul": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() * topTwoNumbers[0].getReal());
                    break;
                }
                case "sub": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() - topTwoNumbers[0].getReal());
                    break;
                }
                default: {
                    throw new PostScriptException("Unknown operator " + operator);
                }
            }
            this.operandStack.push(res);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute " + operator + " operator", e);
        }
    }

    private void executeOperatorOnOneTopNumber(String operator) throws PostScriptException {
        try {
            COSObject res;
            COSObject argument = this.getTopNumber();
            switch (operator) {
                case "abs": {
                    res = COSReal.construct(Math.abs(argument.getReal()));
                    break;
                }
                case "neg": {
                    res = COSReal.construct(-argument.getReal().doubleValue());
                    break;
                }
                case "ceiling": {
                    res = COSInteger.construct((long)Math.ceil(argument.getReal()));
                    break;
                }
                case "floor": {
                    res = COSInteger.construct((long)Math.floor(argument.getReal()));
                    break;
                }
                case "round": {
                    res = COSInteger.construct(Math.round(argument.getReal()));
                    break;
                }
                default: {
                    throw new PostScriptException("Unknown operator " + operator);
                }
            }
            this.operandStack.push(res);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute " + operator + " operator", e);
        }
    }

    private void length() throws PostScriptException {
        COSObject topObject = this.popTopObject();
        if (topObject.getType().isDictionaryBased() || topObject.getType() == COSObjType.COS_ARRAY) {
            this.operandStack.push(COSInteger.construct(topObject.size().intValue()));
            return;
        }
        throw new PostScriptException("Can't execute length operator");
    }

    private void def() {
        if (this.operandStack.size() > 1) {
            COSObject value = this.operandStack.pop();
            COSObject key = this.operandStack.pop();
            COSObjType keyType = key.getType();
            if (keyType == COSObjType.COS_NAME || keyType == COSObjType.COS_STRING) {
                this.userDict.put(ASAtom.getASAtom(key.getString()), value);
            }
        }
    }

    private void load() throws PostScriptException {
        COSObject key = this.popTopObject();
        if (key.getType() == COSObjType.COS_STRING || key.getType() == COSObjType.COS_NAME) {
            ASAtom mapKey = ASAtom.getASAtom(key.getString());
            if (this.userDict.containsKey(mapKey)) {
                this.operandStack.push(this.userDict.get(mapKey));
            }
            return;
        }
        throw new PostScriptException("Can't execute load operator");
    }

    private void array() throws PostScriptException {
        try {
            COSObject arraySize = this.getTopNumber();
            this.operandStack.push(COSArray.construct(arraySize.getInteger().intValue()));
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute array operator", e);
        }
    }

    private void put() throws PostScriptException {
        try {
            if (this.operandStack.size() >= 3) {
                COSObject toPut = this.operandStack.pop();
                COSObject index = this.getTopNumber();
                COSObject array = this.operandStack.pop();
                if (array.getType() == COSObjType.COS_ARRAY) {
                    array.remove(index.getInteger().intValue());
                    array.insert(index.getInteger().intValue(), toPut);
                    return;
                }
            }
            throw new PostScriptException("Problem with stack");
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute put operator", e);
        }
    }

    private void opFor() throws PostScriptException {
        try {
            if (this.operandStack.empty()) {
                throw new PostScriptException("Problem with stack");
            }
            COSObject proc = this.operandStack.pop();
            if (!(proc instanceof PSProcedure)) {
                throw new PostScriptException("Object is not a procedure");
            }
            COSObject limit = this.getTopNumber();
            COSObject increment = this.getTopNumber();
            COSObject initial = this.getTopNumber();
            for (long i = initial.getInteger().longValue(); i <= limit.getInteger(); i += increment.getInteger().longValue()) {
                this.operandStack.push(COSInteger.construct(i));
                ((PSProcedure)proc).executeProcedure(this.operandStack, this.userDict);
            }
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute for operator", e);
        }
    }

    private COSObject[] getTopTwoNumbers() throws PostScriptException {
        COSObject b;
        COSObject a;
        if (this.operandStack.size() > 1 && (a = this.operandStack.pop()).getType().isNumber() && (b = this.operandStack.pop()).getType().isNumber()) {
            return new COSObject[]{a, b};
        }
        throw new PostScriptException("Stack doesn't have two elements or top two elements are not two numbers");
    }

    private COSObject getTopNumber() throws PostScriptException {
        COSObject object = this.popTopObject();
        if (object.getType().isNumber()) {
            return object;
        }
        throw new PostScriptException("Stack is empty or top element is not a number");
    }

    private COSObject popTopObject() throws PostScriptException {
        if (!this.operandStack.empty()) {
            return this.operandStack.pop();
        }
        throw new PostScriptException("Operand stack is empty");
    }

    private static COSObject psCopyObject(COSObject toCopy) {
        switch (toCopy.getType()) {
            case COS_BOOLEAN: {
                return COSBoolean.construct(toCopy.getBoolean());
            }
            case COS_INTEGER: {
                return COSInteger.construct(toCopy.getInteger());
            }
            case COS_NAME: {
                return COSName.construct(toCopy.getName());
            }
            case COS_REAL: {
                return COSReal.construct(toCopy.getReal());
            }
        }
        return toCopy;
    }
}

