/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.CharTable;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.font.type1.EexecFilterDecode;
import org.verapdf.pd.font.type1.Type1CharStringParser;
import org.verapdf.pd.font.type1.Type1FontProgram;

class Type1PrivateParser
extends BaseParser {
    private static final Logger LOGGER = Logger.getLogger(Type1PrivateParser.class.getCanonicalName());
    private int lenIV;
    private Map<String, Integer> glyphWidths;
    private double[] fontMatrix;
    private boolean isDefaultFontMatrix;

    Type1PrivateParser(InputStream stream, double[] fontMatrix) throws IOException {
        super(stream);
        this.fontMatrix = fontMatrix;
        this.isDefaultFontMatrix = Arrays.equals(this.fontMatrix, Type1FontProgram.DEFAULT_FONT_MATRIX);
        this.lenIV = 4;
    }

    public void parse() throws IOException {
        this.initializeToken();
        this.skipSpaces(true);
        while (this.getToken().type != Token.Type.TT_EOF && !"closefile".equals(this.getToken().getValue())) {
            this.nextToken();
            this.processToken();
        }
    }

    @Override
    protected void readName() throws IOException {
        this.clearToken();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            this.appendToToken(ch);
        }
    }

    private void processToken() throws IOException {
        block16: {
            block0 : switch (this.getToken().type) {
                case TT_NAME: {
                    switch (this.getToken().getValue()) {
                        case "CharStrings": {
                            this.nextToken();
                            int amountOfGlyphs = (int)this.getToken().integer;
                            this.nextToken();
                            this.nextToken();
                            this.nextToken();
                            for (int i = 0; i < amountOfGlyphs; ++i) {
                                this.decodeCharString();
                            }
                            break block16;
                        }
                        case "lenIV": {
                            this.nextToken();
                            if (this.getToken().type == Token.Type.TT_INTEGER) {
                                this.lenIV = (int)this.getToken().integer;
                                break block0;
                            }
                            break block16;
                        }
                        case "Subrs": {
                            this.nextToken();
                            int amountOfSubrs = (int)this.getToken().integer;
                            this.nextToken();
                            for (int i = 0; i < amountOfSubrs; ++i) {
                                this.nextToken();
                                if (!this.getToken().getValue().equals("dup")) break block0;
                                this.nextToken();
                                this.nextToken();
                                long toSkip = this.getToken().integer;
                                this.skipRD();
                                this.skipSpaces();
                                this.source.skip(toSkip);
                                this.nextToken();
                            }
                        }
                    }
                }
            }
        }
    }

    private void decodeCharString() throws IOException {
        if (this.glyphWidths == null) {
            this.glyphWidths = new HashMap<String, Integer>();
        }
        this.nextToken();
        try {
            this.checkTokenType(Token.Type.TT_NAME);
        }
        catch (IOException e) {
            if (this.getToken().type == Token.Type.TT_KEYWORD && this.getToken().getValue().equals("end")) {
                LOGGER.log(Level.FINE, "Error in parsing private data in Type 1 font: incorrect amount of charstings specified.");
                return;
            }
            throw e;
        }
        String glyphName = this.getToken().getValue();
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER);
        long charstringLength = this.getToken().integer;
        this.skipRD();
        this.skipSpaces();
        long beginOffset = this.source.getOffset();
        this.source.skip((int)charstringLength);
        try (ASInputStream chunk = this.source.getStream(beginOffset, charstringLength);
             EexecFilterDecode eexecDecode = new EexecFilterDecode(chunk, true, this.lenIV);
             ASMemoryInStream decodedCharString = new ASMemoryInStream(eexecDecode);){
            Type1CharStringParser parser = new Type1CharStringParser(decodedCharString);
            if (parser.getWidth() != null) {
                if (!this.isDefaultFontMatrix) {
                    this.glyphWidths.put(glyphName, this.applyFontMatrix(parser.getWidth().getReal()));
                } else {
                    this.glyphWidths.put(glyphName, (int)parser.getWidth().getInteger());
                }
            }
            this.nextToken();
        }
    }

    private void checkTokenType(Token.Type expectedType) throws IOException {
        if (this.getToken().type != expectedType) {
            throw new IOException("Error in parsing Private dictionary of font 1 file, expected type " + (Object)((Object)expectedType) + ", but got " + (Object)((Object)this.getToken().type));
        }
    }

    private int applyFontMatrix(float width) {
        return (int)((double)width * (this.fontMatrix[0] * 1000.0));
    }

    Map<String, Integer> getGlyphWidths() {
        return this.glyphWidths;
    }

    private void skipRD() throws IOException {
        int next;
        this.skipSpaces();
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_INTEGER && (next = this.source.read()) != 124) {
            LOGGER.log(Level.FINE, "Error in Type1 private parser in parsing RD in Subrs.");
        }
    }
}

