/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.GFPDFormField;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDFormField;

public class GFPDAcroForm
extends GFPDObject
implements PDAcroForm {
    private static final Logger LOGGER = Logger.getLogger(GFPDAcroForm.class.getCanonicalName());
    public static final String ACRO_FORM_TYPE = "PDAcroForm";
    public static final String FORM_FIELDS = "formFields";

    public GFPDAcroForm(org.verapdf.pd.form.PDAcroForm acroForm) {
        super(acroForm, ACRO_FORM_TYPE);
    }

    @Override
    public Boolean getNeedAppearances() {
        COSObject cosNeedAppearances = ((org.verapdf.pd.form.PDAcroForm)this.simplePDObject).getNeedAppearances();
        if (cosNeedAppearances.getType() == COSObjType.COS_BOOLEAN) {
            return cosNeedAppearances.getBoolean();
        }
        if (cosNeedAppearances.empty()) {
            return null;
        }
        LOGGER.log(Level.SEVERE, "Value of NeedAppearances key is not a boolean. Ignoring NeedAppearances");
        return true;
    }

    @Override
    public Boolean getcontainsXFA() {
        return this.simplePDObject.knownKey(ASAtom.XFA);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "formFields": {
                return this.getFormFields();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFormField> getFormFields() {
        List<org.verapdf.pd.form.PDFormField> fields = ((org.verapdf.pd.form.PDAcroForm)this.simplePDObject).getFields();
        ArrayList<GFPDFormField> formFields = new ArrayList<GFPDFormField>(1);
        for (org.verapdf.pd.form.PDFormField field : fields) {
            formFields.add(GFPDFormField.createTypedFormField(field));
        }
        return Collections.unmodifiableList(formFields);
    }
}

