/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosStream;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.axl.AXLMainXMPPackage;
import org.verapdf.model.impl.axl.AXLXMPPackage;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFPDMetadata
extends GFPDObject
implements org.verapdf.model.pdlayer.PDMetadata {
    private static final Logger LOGGER = Logger.getLogger(GFPDMetadata.class.getCanonicalName());
    public static final String METADATA_TYPE = "PDMetadata";
    public static final String XMP_PACKAGE = "XMPPackage";
    public static final String STREAM = "stream";
    private boolean isMainMetadata;
    private PDMetadata mainMetadata;

    public GFPDMetadata(PDMetadata simplePDObject, Boolean isMainMetadata) {
        super(simplePDObject, METADATA_TYPE);
        this.isMainMetadata = isMainMetadata;
        this.mainMetadata = StaticContainers.getDocument() != null && StaticContainers.getDocument().getCatalog() != null && StaticContainers.getDocument().getCatalog().getMetadata() != null ? StaticContainers.getDocument().getCatalog().getMetadata() : null;
    }

    @Override
    public String getFilter() {
        List<ASAtom> filters = ((PDMetadata)this.simplePDObject).getFilters();
        if (filters != null && !filters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            for (ASAtom filter : filters) {
                result.append(filter.getValue()).append(' ');
            }
            return result.substring(0, result.length() - 1);
        }
        return null;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "XMPPackage": {
                return this.getXMPPackage();
            }
            case "stream": {
                return this.getStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<XMPPackage> getXMPPackage() {
        ArrayList<XMPPackage> xmp;
        block29: {
            xmp = new ArrayList<XMPPackage>(1);
            PDFAFlavour flavour = StaticContainers.getFlavour();
            try (InputStream stream = ((PDMetadata)this.simplePDObject).getStream();){
                if (stream == null) break block29;
                VeraPDFMeta metadata = VeraPDFMeta.parse(stream);
                if (this.isMainMetadata) {
                    xmp.add(new AXLMainXMPPackage(metadata, true, flavour));
                    break block29;
                }
                if (flavour != null && flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) break block29;
                VeraPDFXMPNode mainExtensionNode = null;
                try (InputStream mainStream = this.mainMetadata.getStream();){
                    if (mainStream != null) {
                        VeraPDFMeta mainMeta = VeraPDFMeta.parse(mainStream);
                        mainExtensionNode = mainMeta.getExtensionSchemasNode();
                    }
                    xmp.add(new AXLXMPPackage(metadata, true, mainExtensionNode, flavour));
                }
            }
            catch (XMPException | IOException e) {
                LOGGER.log(Level.FINE, "Problems with parsing metadata. " + e.getMessage(), e);
                if (this.isMainMetadata) {
                    xmp.add(new AXLMainXMPPackage(null, false, flavour));
                }
                if (flavour != null && flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) break block29;
                xmp.add(new AXLXMPPackage(null, false, null, flavour));
            }
        }
        return xmp;
    }

    private List<CosStream> getStream() {
        COSStream stream = ((PDMetadata)this.simplePDObject).getCOSStream();
        if (stream != null) {
            ArrayList<GFCosStream> streams = new ArrayList<GFCosStream>(1);
            streams.add(new GFCosStream(stream));
            return Collections.unmodifiableList(streams);
        }
        return Collections.emptyList();
    }

    public static boolean isMetadataObject(COSObject obj) {
        return obj != null && obj.getType() == COSObjType.COS_STREAM && obj.getNameKey(ASAtom.TYPE) == ASAtom.METADATA && obj.getNameKey(ASAtom.SUBTYPE).equals(ASAtom.getASAtom("XML"));
    }
}

