/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.gfse.GFSEGeneral;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.TaggedPDFHelper;

public class GFPDStructElem
extends GFPDObject
implements org.verapdf.model.pdlayer.PDStructElem {
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";

    protected GFPDStructElem(PDStructElem structElemDictionary, String type) {
        super(structElemDictionary, type);
        ASAtom subtype = this.simplePDObject.getNameKey(ASAtom.S);
        if (subtype != null) {
            this.id = super.getID() + " " + subtype.getValue();
        }
    }

    public GFPDStructElem(PDStructElem structElemDictionary) {
        this(structElemDictionary, STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public String getType() {
        ASAtom type = ((PDStructElem)this.simplePDObject).getType();
        return type == null ? null : type.getValue();
    }

    @Override
    public String getkidsStandardTypes() {
        return this.getChildren().stream().map(org.verapdf.model.pdlayer.PDStructElem::getstandardType).filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    @Override
    public Boolean gethasContentItems() {
        COSObject children = this.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem(children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (!TaggedPDFHelper.isContentItem(elem)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getstandardType() {
        return GFPDStructElem.getStructureElementStandardType((PDStructElem)this.simplePDObject);
    }

    public static String getStructureElementStandardType(PDStructElem pdStructElem) {
        if (StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_4) {
            StructureType defaultStructureType = pdStructElem.getDefaultStructureType();
            if (defaultStructureType != null) {
                return defaultStructureType.getType().getValue();
            }
        } else {
            StructureType type = pdStructElem.getStructureType();
            if (type != null) {
                return StaticContainers.getRoleMapHelper().getStandardType(type.getType());
            }
        }
        return null;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> getChildren() {
        List<PDStructElem> elements = ((PDStructElem)this.simplePDObject).getChildren();
        if (!elements.isEmpty()) {
            ArrayList<GFSEGeneral> res = new ArrayList<GFSEGeneral>(elements.size());
            for (PDStructElem element : elements) {
                res.add(GFSEGeneral.createTypedStructElem(element));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

