/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;

public class FunctionParser
extends BaseParser {
    private static final Logger LOGGER = Logger.getLogger(FunctionParser.class.getCanonicalName());
    private static final Set<String> FUNCTION_KEYWORDS;
    private List<COSObject> operators = new ArrayList<COSObject>();

    public FunctionParser(InputStream functionStream) throws IOException {
        super(functionStream);
    }

    public void parse() throws IOException {
        this.initializeToken();
        this.skipSpaces(true);
        while (this.getToken().type != Token.Type.TT_EOF) {
            this.nextToken();
            this.processToken();
        }
    }

    private void processToken() {
        switch (this.getToken().type) {
            case TT_NONE: 
            case TT_EOF: {
                break;
            }
            case TT_KEYWORD: {
                if (FUNCTION_KEYWORDS.contains(this.getToken().getValue())) break;
                LOGGER.log(Level.WARNING, "Invalid keyword in Function");
                break;
            }
            case TT_INTEGER: {
                this.operators.add(COSInteger.construct(this.getToken().integer));
                break;
            }
            case TT_REAL: {
                this.operators.add(COSReal.construct(this.getToken().real));
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Invalid object type in Function");
            }
        }
    }

    public List<COSObject> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("abs");
        tempSet.add("cvi");
        tempSet.add("floor");
        tempSet.add("mod");
        tempSet.add("sin");
        tempSet.add("add");
        tempSet.add("cvr");
        tempSet.add("idiv");
        tempSet.add("mul");
        tempSet.add("sqrt");
        tempSet.add("atan");
        tempSet.add("div");
        tempSet.add("ln");
        tempSet.add("neg");
        tempSet.add("sub");
        tempSet.add("ceiling");
        tempSet.add("exp");
        tempSet.add("log");
        tempSet.add("round");
        tempSet.add("truncate");
        tempSet.add("cos");
        tempSet.add("and");
        tempSet.add("false");
        tempSet.add("le");
        tempSet.add("not");
        tempSet.add("true");
        tempSet.add("bitshift");
        tempSet.add("ge");
        tempSet.add("lt");
        tempSet.add("or");
        tempSet.add("xor");
        tempSet.add("eq");
        tempSet.add("gt");
        tempSet.add("ne");
        tempSet.add("if");
        tempSet.add("ifelse");
        tempSet.add("copy");
        tempSet.add("exch");
        tempSet.add("pop");
        tempSet.add("dup");
        tempSet.add("index");
        tempSet.add("roll");
        tempSet.add("{");
        tempSet.add("}");
        FUNCTION_KEYWORDS = Collections.unmodifiableSet(tempSet);
    }
}

