/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.processor.reports.Check;

final class CheckImpl
implements Check {
    @XmlAttribute
    private final String status;
    @XmlElement
    private final String context;

    private CheckImpl(TestAssertion.Status status, String context) {
        this.status = status.toString();
        this.context = context;
    }

    private CheckImpl() {
        this(TestAssertion.Status.PASSED, "");
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    static final Check fromValue(TestAssertion assertion) {
        if (assertion == null) {
            throw new IllegalArgumentException("Argument assertion con not be null");
        }
        return new CheckImpl(assertion.getStatus(), assertion.getLocation().getContext());
    }

    static class Adapter
    extends XmlAdapter<CheckImpl, Check> {
        Adapter() {
        }

        @Override
        public Check unmarshal(CheckImpl check) {
            return check;
        }

        @Override
        public CheckImpl marshal(Check check) {
            return (CheckImpl)check;
        }
    }
}

