/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import com.adobe.xmp.impl.VeraPDFMeta;
import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLPDFAIdentification;
import org.verapdf.model.impl.axl.AXLPDFUAIdentification;
import org.verapdf.model.impl.axl.AXLXMPPackage;
import org.verapdf.model.xmplayer.MainXMPPackage;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class AXLMainXMPPackage
extends AXLXMPPackage
implements MainXMPPackage {
    public static final String MAIN_XMP_PACKAGE_TYPE = "MainXMPPackage";
    public static final String IDENTIFICATION = "Identification";
    public static final String UAIDENTIFICATION = "UAIdentification";

    public AXLMainXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid, PDFAFlavour flavour) {
        super(xmpMetadata, isSerializationValid, true, false, null, MAIN_XMP_PACKAGE_TYPE, flavour);
    }

    public AXLMainXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid, boolean isClosedChoiceCheck, PDFAFlavour flavour) {
        super(xmpMetadata, isSerializationValid, true, isClosedChoiceCheck, null, MAIN_XMP_PACKAGE_TYPE, flavour);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Identification": {
                return this.getIdentification();
            }
            case "UAIdentification": {
                return this.getUAIdentification();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLPDFUAIdentification> getUAIdentification() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null) {
            for (VeraPDFXMPNode node : xmpMetadata.getProperties()) {
                if (!"http://www.aiim.org/pdfua/ns/id/".equals(node.getNamespaceURI())) continue;
                ArrayList<AXLPDFUAIdentification> res = new ArrayList<AXLPDFUAIdentification>(1);
                res.add(new AXLPDFUAIdentification(xmpMetadata));
                return Collections.unmodifiableList(res);
            }
        }
        return Collections.emptyList();
    }

    private List<AXLPDFAIdentification> getIdentification() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null) {
            for (VeraPDFXMPNode node : xmpMetadata.getProperties()) {
                if (!"http://www.aiim.org/pdfa/ns/id/".equals(node.getNamespaceURI())) continue;
                ArrayList<AXLPDFAIdentification> res = new ArrayList<AXLPDFAIdentification>(1);
                res.add(new AXLPDFAIdentification(xmpMetadata));
                return Collections.unmodifiableList(res);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getdc_title() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null) {
            for (VeraPDFXMPNode node : xmpMetadata.getProperties()) {
                if (!"http://purl.org/dc/elements/1.1/".equals(node.getNamespaceURI()) || !"dc".equals(node.getPrefix()) || !"title".equals(node.getName())) continue;
                return node.getLanguageAlternative();
            }
        }
        return null;
    }
}

