/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.validation.profiles.ErrorDetails;
import org.verapdf.pdfa.validation.profiles.ErrorDetailsImpl;
import org.verapdf.pdfa.validation.profiles.Reference;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.RuleIdImpl;

@XmlRootElement(name="rule")
final class RuleImpl
implements Rule {
    private static final RuleImpl DEFAULT = new RuleImpl();
    @XmlElement
    private final RuleId id;
    @XmlAttribute
    private final String object;
    @XmlAttribute
    private final Boolean deferred;
    @XmlElement
    private final String description;
    @XmlElement
    private final String test;
    @XmlElement
    private final ErrorDetails error;
    @XmlElementWrapper
    @XmlElement(name="reference")
    private final List<Reference> references = new ArrayList<Reference>();

    private RuleImpl() {
        this(RuleIdImpl.defaultInstance(), "object", null, "description", "test", ErrorDetailsImpl.defaultInstance(), Collections.emptyList());
    }

    private RuleImpl(RuleId id, String object, Boolean deferred, String description, String test, ErrorDetails error, List<Reference> references) {
        this.id = id;
        this.object = object;
        this.deferred = deferred;
        this.description = description;
        this.test = test;
        this.error = error;
        this.references.addAll(references);
    }

    @Override
    public RuleId getRuleId() {
        return this.id;
    }

    @Override
    public String getObject() {
        return this.object;
    }

    @Override
    public Boolean getDeferred() {
        return this.deferred;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public ErrorDetails getError() {
        return this.error;
    }

    @Override
    public List<Reference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleImpl)) {
            return false;
        }
        RuleImpl rule = (RuleImpl)o;
        if (this.id != null ? !this.id.equals(rule.id) : rule.id != null) {
            return false;
        }
        if (this.object != null ? !this.object.equals(rule.object) : rule.object != null) {
            return false;
        }
        if (this.deferred != null ? !this.deferred.equals(rule.deferred) : rule.deferred != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(rule.description) : rule.description != null) {
            return false;
        }
        if (this.test != null ? !this.test.equals(rule.test) : rule.test != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(rule.error) : rule.error != null) {
            return false;
        }
        return this.references != null ? this.references.equals(rule.references) : rule.references == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        result = 31 * result + (this.deferred != null ? this.deferred.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.test != null ? this.test.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.references != null ? this.references.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Rule [id=" + this.id + ", object=" + this.object + ", deferred=" + this.deferred + ", description=" + this.description + ", test=" + this.test + ", error=" + this.error + ", references=" + this.references + "]";
    }

    static RuleImpl defaultInstance() {
        return DEFAULT;
    }

    static RuleImpl fromValues(RuleId id, String object, Boolean deferred, String description, String test, ErrorDetails error, List<Reference> references) {
        return new RuleImpl(RuleIdImpl.fromRuleId(id), object, deferred, description, test, error, references);
    }

    static RuleImpl fromRule(Rule toConvert) {
        return RuleImpl.fromValues(RuleIdImpl.fromRuleId(toConvert.getRuleId()), toConvert.getObject(), toConvert.getDeferred(), toConvert.getDescription(), toConvert.getTest(), toConvert.getError(), toConvert.getReferences());
    }

    static class Adapter
    extends XmlAdapter<RuleImpl, Rule> {
        Adapter() {
        }

        @Override
        public Rule unmarshal(RuleImpl ruleImpl) {
            return ruleImpl;
        }

        @Override
        public RuleImpl marshal(Rule rule) {
            return (RuleImpl)rule;
        }
    }
}

