/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.pd.font.GFPDSimpleFont;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.AdobeGlyphList;
import org.verapdf.pd.font.truetype.PDTrueTypeFont;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;

public class GFPDTrueTypeFont
extends GFPDSimpleFont
implements org.verapdf.model.pdlayer.PDTrueTypeFont {
    private static final Logger LOGGER = Logger.getLogger(GFPDTrueTypeFont.class.getCanonicalName());
    public static final String TRUETYPE_FONT_TYPE = "PDTrueTypeFont";

    public GFPDTrueTypeFont(PDTrueTypeFont font, RenderingMode renderingMode) {
        super(font, renderingMode, TRUETYPE_FONT_TYPE);
        FontProgram program;
        if (font != null && (program = font.getFontProgram()) != null) {
            try {
                if (!program.isAttemptedParsing()) {
                    program.parseFont();
                }
                this.fontProgramParsed = program.isSuccessfulParsing();
                this.pdFont.setSuccessfullyParsed(program.isSuccessfulParsing());
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't parse font program of font " + font.getName(), e);
                this.fontProgramParsed = false;
                this.pdFont.setSuccessfullyParsed(false);
            }
        }
    }

    @Override
    public Boolean getdifferencesAreUnicodeCompliant() {
        COSObject differences;
        if (!this.fontProgramParsed) {
            return false;
        }
        FontProgram font = this.pdFont.getFontProgram();
        if (font instanceof OpenTypeFontProgram) {
            font = ((OpenTypeFontProgram)font).getFont();
        }
        if (!((TrueTypeFontProgram)font).isCmapPresent(3, 1)) {
            return false;
        }
        COSObject encoding = this.pdFont.getEncoding();
        if (!encoding.empty() && encoding.getType() != COSObjType.COS_NAME && !(differences = encoding.getKey(ASAtom.DIFFERENCES)).empty() && differences.getType() == COSObjType.COS_ARRAY) {
            for (COSObject diff : (COSArray)differences.getDirectBase()) {
                if (diff.getType() != COSObjType.COS_NAME || AdobeGlyphList.contains(diff.getString())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean getisStandard() {
        return false;
    }
}

