/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import java.awt.color.ColorSpace;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.tools.TypeConverter;

public abstract class PDCIEDictionaryBased
extends PDColorSpace {
    private static final double[] DEFAULT_BLACK_POINT = new double[]{0.0, 0.0, 0.0};
    protected COSObject dictionary;
    protected double wpX = 1.0;
    protected double wpY = 1.0;
    protected double wpZ = 1.0;

    protected PDCIEDictionaryBased() {
        this(COSDictionary.construct());
    }

    protected PDCIEDictionaryBased(COSObject obj) {
        super(obj);
        COSObject dict = obj.at(1);
        this.dictionary = dict == null || dict.getType() != COSObjType.COS_DICT ? COSDictionary.construct() : dict;
        this.fillWhitepointCache(this.getWhitePoint());
    }

    private void fillWhitepointCache(double[] whitepoint) {
        this.wpX = whitepoint[0];
        this.wpY = whitepoint[1];
        this.wpZ = whitepoint[2];
    }

    protected double[] convXYZtoRGB(double x, double y, double z) {
        float[] rgb = ColorSpace.getInstance(1001).toRGB(new float[]{(float)Math.max(0.0, x), (float)Math.max(0.0, y), (float)Math.max(0.0, z)});
        return new double[]{rgb[0], rgb[1], rgb[2]};
    }

    public double[] getWhitePoint() {
        return PDCIEDictionaryBased.getTristimulus(this.dictionary.getKey(ASAtom.WHITE_POINT));
    }

    public double[] getBlackPoint() {
        double[] res = PDCIEDictionaryBased.getTristimulus(this.dictionary.getKey(ASAtom.BLACK_POINT));
        return res == null ? DEFAULT_BLACK_POINT : res;
    }

    private static double[] getTristimulus(COSObject object) {
        return TypeConverter.getRealArray(object, 3, "Tristimulus");
    }
}

