/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSString;
import org.verapdf.features.objects.SignatureFeaturesObjectAdapter;
import org.verapdf.pd.PDSignature;

public class GFSignatureFeaturesObjectAdapter
implements SignatureFeaturesObjectAdapter {
    private PDSignature signature;

    public GFSignatureFeaturesObjectAdapter(PDSignature signature) {
        this.signature = signature;
    }

    @Override
    public InputStream getData() {
        if (this.signature != null && !this.signature.empty()) {
            COSString contents = this.signature.getContents();
            return contents == null ? null : new ByteArrayInputStream(contents.get());
        }
        return null;
    }

    @Override
    public String getFilter() {
        if (this.signature != null && !this.signature.empty()) {
            ASAtom filter = this.signature.getFilter();
            return filter == null ? null : filter.getValue();
        }
        return null;
    }

    @Override
    public String getSubFilter() {
        if (this.signature != null && !this.signature.empty()) {
            ASAtom subfilter = this.signature.getSubfilter();
            return subfilter == null ? null : subfilter.getValue();
        }
        return null;
    }

    @Override
    public String getHexContents() {
        COSString contents;
        if (this.signature != null && !this.signature.empty() && (contents = this.signature.getContents()) != null) {
            return contents.getHexString();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.signature != null && !this.signature.empty()) {
            return this.signature.getName();
        }
        return null;
    }

    @Override
    public Calendar getSignDate() {
        if (this.signature != null && !this.signature.empty()) {
            return this.signature.getSignDate();
        }
        return null;
    }

    @Override
    public String getLocation() {
        if (this.signature != null && !this.signature.empty()) {
            return this.signature.getLocation();
        }
        return null;
    }

    @Override
    public String getReason() {
        if (this.signature != null && !this.signature.empty()) {
            return this.signature.getReason();
        }
        return null;
    }

    @Override
    public String getContactInfo() {
        if (this.signature != null && !this.signature.empty()) {
            ASAtom filter = this.signature.getFilter();
            return filter == null ? null : filter.getValue();
        }
        return null;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.signature != null && !this.signature.empty();
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }
}

