/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASOutputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.filters.COSFilterRegistry;
import org.verapdf.pd.PDObject;

public class COSFilters
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(COSFilters.class.getCanonicalName());
    private List<ASAtom> entries = new ArrayList<ASAtom>();

    public COSFilters() {
    }

    public COSFilters(COSObject object) {
        this();
        this.setObject(object);
    }

    public ASInputStream getInputStream(ASInputStream inputStream, COSObject decodeParams) throws IOException {
        int i;
        ArrayList<COSDictionary> decodeParameters = null;
        if (!decodeParams.empty()) {
            if (decodeParams.getType().equals((Object)COSObjType.COS_DICT)) {
                decodeParameters = new ArrayList(1);
                decodeParameters.add((COSDictionary)decodeParams.getDirectBase());
            } else if (decodeParams.getType().equals((Object)COSObjType.COS_ARRAY)) {
                decodeParameters = new ArrayList(decodeParams.size());
                for (i = 0; i < decodeParams.size(); ++i) {
                    COSObjType paramsType = decodeParams.at(i).getType();
                    if (decodeParams.at(i).empty() || paramsType == COSObjType.COS_NULL) {
                        decodeParameters.add((COSDictionary)COSDictionary.construct().get());
                        continue;
                    }
                    if (paramsType != COSObjType.COS_DICT) {
                        throw new IOException("DecodeParams shall be a dictionary or array of dictionaries.");
                    }
                    decodeParameters.add((COSDictionary)decodeParams.at(i).getDirectBase());
                }
            }
        }
        if (decodeParameters == null) {
            decodeParameters = new ArrayList<COSDictionary>(this.entries.size());
            for (i = 0; i < this.entries.size(); ++i) {
                decodeParameters.add((COSDictionary)COSDictionary.construct().get());
            }
        }
        if (decodeParameters.size() != this.entries.size()) {
            LOGGER.log(Level.FINE, "Amount of DecodeParams dictionaries and amount of decode filters in COSStream shall be equal.");
        }
        for (i = 0; i < this.entries.size(); ++i) {
            inputStream = COSFilterRegistry.getDecodeFilter(this.entries.get(i), inputStream, (COSDictionary)decodeParameters.get(i));
        }
        return inputStream;
    }

    public ASOutputStream getOutputStream(ASOutputStream outputStream) throws IOException {
        for (ASAtom asAtom : this.entries) {
            outputStream = COSFilterRegistry.getEncodeFilter(asAtom, outputStream);
        }
        return outputStream;
    }

    public int size() {
        return this.entries.size();
    }

    public List<ASAtom> getFilters() {
        return this.entries;
    }

    @Override
    protected void updateToObject() {
        COSObject filters = this.getObject();
        filters.clearArray();
        for (ASAtom entry : this.entries) {
            filters.add(COSName.construct(entry));
        }
    }

    @Override
    protected void updateFromObject() {
        COSObject filters = this.getObject();
        if (filters.getType().equals((Object)COSObjType.COS_ARRAY)) {
            int size = filters.size();
            this.entries.clear();
            for (int i = 0; i < size; ++i) {
                this.entries.add(filters.at(i).getName());
            }
        } else if (filters.getType().equals((Object)COSObjType.COS_NAME)) {
            this.entries.clear();
            this.entries.add(filters.getName());
        }
    }
}

