/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports.multithread.writer;

import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.writer.JsonReportWriter;
import org.verapdf.processor.reports.multithread.writer.MrrReportWriter;
import org.verapdf.processor.reports.multithread.writer.RawReportWriter;
import org.verapdf.processor.reports.multithread.writer.TextReportWriter;

public abstract class ReportWriter {
    private static final Logger LOGGER = Logger.getLogger(ReportWriter.class.getCanonicalName());
    protected PrintWriter outputStreamWriter;
    private PrintWriter errorStreamWriter;

    protected ReportWriter(PrintWriter outputStreamWriter, PrintWriter errorStreamWriter) {
        this.outputStreamWriter = outputStreamWriter;
        this.errorStreamWriter = errorStreamWriter;
    }

    public static ReportWriter newInstance(OutputStream os, FormatOption outputFormat, OutputStream errorStream) {
        PrintWriter outputStreamWriter = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        PrintWriter errorStreamWriter = new PrintWriter(new OutputStreamWriter(errorStream, StandardCharsets.UTF_8));
        try {
            switch (outputFormat) {
                case TEXT: {
                    return new TextReportWriter(outputStreamWriter, errorStreamWriter);
                }
                case MRR: 
                case XML: {
                    return new MrrReportWriter(outputStreamWriter, errorStreamWriter);
                }
                case RAW: {
                    return new RawReportWriter(outputStreamWriter, errorStreamWriter);
                }
                case JSON: {
                    return new JsonReportWriter(outputStreamWriter, errorStreamWriter);
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't create new ReportWriter instance", e);
            return null;
        }
    }

    public abstract void write(ResultStructure var1);

    public abstract void startDocument();

    public abstract void endDocument();

    protected void merge(File report, PrintWriter destination) {
        try (FileReader fis = new FileReader(report);){
            int read;
            while ((read = fis.read()) != -1) {
                destination.write(read);
            }
            destination.flush();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't read from report file", e);
        }
    }

    protected void deleteTemp(ResultStructure result) {
        this.deleteFile(result.getReportFile());
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public void closeOutputStream() {
        this.outputStreamWriter.flush();
        this.outputStreamWriter.close();
    }
}

