/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.CharTable;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSString;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.operator.InlineImageOperator;
import org.verapdf.operator.Operator;
import org.verapdf.parser.NotSeekableCOSParser;
import org.verapdf.parser.Token;

public class PDFStreamParser
extends NotSeekableCOSParser {
    private static final Logger LOGGER = Logger.getLogger(PDFStreamParser.class.getCanonicalName());
    private static final int INLINE_IMAGE_BUFFER_SIZE = 8192;
    private final List<Object> tokens = new ArrayList<Object>();
    private List<Closeable> imageDataStreams = new ArrayList<Closeable>();
    private COSDictionary lastInlineImageDict;

    public PDFStreamParser(ASInputStream stream) throws IOException {
        super(stream);
        this.initializeToken();
    }

    public void parseTokens() throws IOException {
        Object token = this.parseNextToken();
        while (token != null) {
            if (token instanceof COSObject) {
                token = ((COSObject)token).get();
            }
            this.tokens.add(token);
            token = this.parseNextToken();
        }
    }

    public List<Object> getTokens() {
        return this.tokens;
    }

    public Iterator<Object> getTokensIterator() {
        return new Iterator<Object>(){
            private Object token;

            private void tryNext() {
                try {
                    if (this.token == null) {
                        this.token = PDFStreamParser.this.parseNextToken();
                    }
                }
                catch (IOException e) {
                    throw new VeraPDFParserException(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.tryNext();
                return this.token != null;
            }

            @Override
            public Object next() {
                this.tryNext();
                Object tmp = this.token;
                if (tmp == null) {
                    throw new NoSuchElementException();
                }
                this.token = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object parseNextToken() throws IOException {
        Object result = null;
        this.skipSpaces(true);
        byte nextByte = this.source.peek();
        if (nextByte == -1) {
            return null;
        }
        byte c = nextByte;
        switch (c) {
            case 40: {
                this.nextToken();
                result = COSString.construct(this.getToken().getByteValue());
                break;
            }
            case 60: {
                this.source.readByte();
                c = this.source.peek();
                this.source.unread();
                if (c == 60) {
                    result = this.getDictionary();
                    break;
                }
                this.nextToken();
                Token token = this.getToken();
                result = COSString.construct(token.getByteValue(), true, token.getHexCount(), token.isContainsOnlyHex());
                break;
            }
            case 91: {
                result = this.getArray();
                break;
            }
            case 47: {
                result = this.getName();
                break;
            }
            case 110: {
                String nullString = this.readUntilDelimiter();
                if (nullString.equals("null")) {
                    result = new COSObject(COSNull.NULL);
                    break;
                }
                result = Operator.getOperator(nullString);
                break;
            }
            case 102: 
            case 116: {
                String line = this.readUntilDelimiter();
                if (line.equals("true")) {
                    result = new COSObject(COSBoolean.TRUE);
                    break;
                }
                if (line.equals("false")) {
                    result = new COSObject(COSBoolean.FALSE);
                    break;
                }
                result = Operator.getOperator(line);
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Token token = this.getToken();
                this.nextToken();
                if (token.type.equals((Object)Token.Type.TT_REAL)) {
                    result = COSReal.construct(token.real);
                    break;
                }
                if (!token.type.equals((Object)Token.Type.TT_INTEGER)) break;
                result = COSInteger.construct(token.integer);
                break;
            }
            case 66: {
                COSDictionary imageParameters;
                Token token = this.getToken();
                this.nextToken();
                result = Operator.getOperator(token.getValue());
                if (!(result instanceof InlineImageOperator)) break;
                InlineImageOperator imageOperator = (InlineImageOperator)result;
                this.lastInlineImageDict = imageParameters = (COSDictionary)COSDictionary.construct().get();
                imageOperator.setImageParameters(imageParameters);
                Object nextToken = this.parseNextToken();
                while (nextToken instanceof COSObject && ((COSObject)nextToken).getType() == COSObjType.COS_NAME) {
                    Object value = this.parseNextToken();
                    if (value instanceof COSObject) {
                        imageParameters.setKey(((COSObject)nextToken).getName(), (COSObject)value);
                    } else {
                        LOGGER.log(Level.FINE, "Unexpected token in BI operator parsing: " + value.toString());
                    }
                    nextToken = this.parseNextToken();
                }
                if (nextToken instanceof InlineImageOperator) {
                    imageOperator.setImageData(((InlineImageOperator)nextToken).getImageData());
                    break;
                }
                throw new IOException("Unexpected token instead of operator in operator parsing: " + nextToken.toString());
            }
            case 73: {
                if (this.source.readByte() != 73 || this.source.readByte() != 68) {
                    throw new IOException("Corrupted inline image operator");
                }
                if (CharTable.isSpace(this.source.peek())) {
                    this.source.readByte();
                }
                ASInputStream imageDataStream = this.readInlineImage();
                result = Operator.getOperator("ID");
                this.imageDataStreams.add(imageDataStream);
                ((InlineImageOperator)result).setImageData(imageDataStream);
                break;
            }
            default: {
                String operator = this.nextOperator();
                result = operator.length() == 0 ? null : Operator.getOperator(operator);
            }
        }
        return result;
    }

    protected String nextOperator() throws IOException {
        this.skipSpaces();
        StringBuilder buffer = new StringBuilder(5);
        byte nextByte = this.source.peek();
        while (!(this.source.isEOF() || CharTable.isSpace(nextByte) || nextByte == 93 || nextByte == 91 || nextByte == 60 || nextByte == 40 || nextByte == 47 || nextByte >= 48 && nextByte <= 57)) {
            byte currentByte = this.source.readByte();
            buffer.append((char)currentByte);
            if (this.source.isEOF()) continue;
            nextByte = this.source.peek();
            if (currentByte != 100 || nextByte != 48 && nextByte != 49) continue;
            buffer.append((char)this.source.readByte());
            nextByte = this.source.peek();
        }
        return buffer.toString();
    }

    private ASInputStream readInlineImage() throws IOException {
        Long l;
        this.source.resetReadCounter();
        ArrayList<Byte> image = new ArrayList<Byte>(8192);
        byte previousByte = this.source.readByte();
        byte currentByte = this.source.readByte();
        image.add(previousByte);
        image.add(currentByte);
        Long l2 = l = this.lastInlineImageDict == null ? new Long(0L) : this.lastInlineImageDict.getIntegerKey(ASAtom.L);
        if (l == null) {
            l = this.lastInlineImageDict.getIntegerKey(ASAtom.LENGTH);
        }
        while (!(this.source.isEOF() || previousByte == 69 && currentByte == 73 && this.isSourceAfterImage(l) && CharTable.isSpace(this.source.peek()))) {
            previousByte = currentByte;
            currentByte = this.source.readByte();
            image.add(currentByte);
        }
        return new ASMemoryInStream(PDFStreamParser.getByteArrayFromArrayList(image), this.source.getReadCounter(), false);
    }

    private boolean isSourceAfterImage(Long length) {
        return length == null || (long)this.source.getReadCounter() >= length;
    }

    public List<Closeable> getImageDataStreams() {
        return this.imageDataStreams;
    }

    public static byte[] getByteArrayFromArrayList(ArrayList<Byte> list) {
        byte[] res = new byte[list.size()];
        int i = 0;
        for (Byte b : list) {
            res[i++] = b;
        }
        return res;
    }
}

