/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.io.IOException;
import java.io.InputStream;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.io.InternalInputStream;

public abstract class SeekableInputStream
extends ASInputStream {
    private static final int MAX_BUFFER_SIZE = 10240;

    public abstract void seek(long var1) throws IOException;

    public abstract long getOffset() throws IOException;

    public abstract long getCurrentOffset();

    public abstract long getStreamLength() throws IOException;

    public abstract int peek() throws IOException;

    public abstract ASInputStream getStream(long var1, long var3) throws IOException;

    public abstract SeekableInputStream getSeekableStream(long var1, long var3) throws IOException;

    @Override
    public void incrementResourceUsers() {
        this.resourceUsers.increment();
    }

    @Override
    public void decrementResourceUsers() {
        this.resourceUsers.decrement();
    }

    public boolean isEOF() throws IOException {
        return this.getOffset() == this.getStreamLength();
    }

    public void unread() throws IOException {
        this.seek(this.getOffset() - 1L);
    }

    public void unread(int count) throws IOException {
        this.seek(this.getOffset() - (long)count);
    }

    public void seekFromCurrentPosition(long pos) throws IOException {
        this.seek(this.getOffset() + pos);
    }

    public void seekFromEnd(long pos) throws IOException {
        long size = this.getStreamLength();
        this.seek(size - pos);
    }

    public byte readByte() throws IOException {
        int next = this.read();
        if (next < 0) {
            throw new IOException("End of file is reached");
        }
        return (byte)next;
    }

    public static SeekableInputStream getSeekableStream(InputStream stream) throws IOException {
        if (stream instanceof SeekableInputStream) {
            SeekableInputStream seekableStream = (SeekableInputStream)stream;
            long offset = seekableStream.getOffset();
            long remaining = seekableStream.getStreamLength() - offset;
            SeekableInputStream result = seekableStream.getSeekableStream(offset, remaining);
            seekableStream.seekFromEnd(0L);
            return result;
        }
        return SeekableInputStream.getSeekableStream(stream, null);
    }

    public static SeekableInputStream getSeekableStream(InputStream stream, Integer maxStreamSize) throws IOException {
        int totalRead;
        int read;
        int maximumSize;
        byte[] buffer = new byte[]{};
        byte[] temp = new byte[2048];
        int n = maximumSize = maxStreamSize == null ? 10240 : Math.min(10240, maxStreamSize + 1);
        for (totalRead = 0; totalRead < maximumSize; totalRead += read) {
            read = stream.read(temp);
            if (read == -1) {
                return new ASMemoryInStream(buffer, buffer.length, false);
            }
            buffer = ASBufferedInFilter.concatenate(buffer, buffer.length, temp, read);
        }
        if (maxStreamSize != null && totalRead > maxStreamSize) {
            throw new VeraPDFParserException("Maximum allowed stream size exceeded");
        }
        return InternalInputStream.createConcatenated(buffer, stream, maxStreamSize);
    }
}

