/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MiniLogoPanel
extends JPanel {
    private static final long serialVersionUID = -199053265127458738L;

    MiniLogoPanel(String logoPath) throws IOException {
        this.setLayout(new FlowLayout(0));
        JLabel label = new JLabel("     Please choose a PDF and a PDF flavour or custom validation profile, then press \"Execute\"");
        label.setToolTipText("<html>PDF flavour: the PDF/A or PDF/UA part and conformance level<br>Validation profile: custom collection of validation rules</html>");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoPath);){
            final BufferedImage image = ImageIO.read(is);
            Icon icon = new Icon(){
                private static final double SCALE = 0.3;

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    g.drawImage(image, 0, 0, this.getIconWidth(), this.getIconHeight(), 0, 0, image.getWidth(), image.getHeight(), null);
                }

                @Override
                public int getIconWidth() {
                    return (int)((double)image.getWidth() * 0.3);
                }

                @Override
                public int getIconHeight() {
                    return (int)((double)image.getHeight() * 0.3);
                }
            };
            label.setIcon(icon);
        }
        this.add(label);
    }
}

