/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.EnumSet;
import org.verapdf.policy.SchematronOperation;

public class Feature {
    private final String featureName;
    private final String featureXPath;
    private final FeatureType featureType;

    public Feature(String featureName, String featureXPath, FeatureType featureType) {
        this.featureName = featureName;
        this.featureXPath = featureXPath;
        this.featureType = featureType;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureXPath() {
        return this.featureXPath;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public static enum FeatureType {
        BOOLEAN(SchematronOperation.PRESENT, SchematronOperation.NOT_PRESENT, SchematronOperation.IS_TRUE, SchematronOperation.IS_FALSE),
        NUMBER(SchematronOperation.PRESENT, SchematronOperation.NOT_PRESENT, SchematronOperation.IS_EQUAL, SchematronOperation.NOT_EQUAL, SchematronOperation.IS_GREATER, SchematronOperation.IS_GREATER_OR_EQUAL, SchematronOperation.IS_LESS, SchematronOperation.IS_LESS_OR_EQUAL),
        STRING(SchematronOperation.PRESENT, SchematronOperation.NOT_PRESENT, SchematronOperation.IS_EQUAL, SchematronOperation.NOT_EQUAL, SchematronOperation.STARTS_WITH, SchematronOperation.CONTAINS);

        private EnumSet<SchematronOperation> legalOperations;

        private FeatureType(SchematronOperation op, SchematronOperation ... operations) {
            this.legalOperations = EnumSet.of(op, operations);
        }

        public EnumSet<SchematronOperation> getLegalOperations() {
            return EnumSet.copyOf(this.legalOperations);
        }
    }
}

