/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDGroup;
import org.verapdf.gf.model.impl.pd.GFPDSemanticContentStream;
import org.verapdf.gf.model.impl.pd.GFTransparencyColorSpace;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDXForm;
import org.verapdf.model.pdlayer.TransparencyColorSpace;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFPDXForm
extends GFPDXObject
implements PDXForm {
    public static final String X_FORM_TYPE = "PDXForm";
    public static final String GROUP = "Group";
    public static final String CONTENT_STREAM = "contentStream";
    public static final String TRANSPARENCY_COLOR_SPACE = "transparencyColorSpace";
    public static final String PARENT_TRANSPARENCY_COLOR_SPACE = "parentTransparencyColorSpace";
    private List<PDContentStream> contentStreams = null;
    private List<org.verapdf.model.pdlayer.PDGroup> groups = null;
    private boolean groupContainsTransparency = false;
    private boolean contentStreamContainsTransparency = false;
    private final GraphicState inheritedGraphicState;
    private final COSObject parentStructElem;
    private final String parentsTags;
    private final String defaultLang;
    private final PDColorSpace blendingColorSpace;

    public GFPDXForm(org.verapdf.pd.images.PDXForm simplePDObject, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, COSObject parentStructElem, String parentsTags, String defaultLang) {
        super(simplePDObject, resourcesHandler.getExtendedResources(simplePDObject.getResources()), X_FORM_TYPE);
        this.inheritedGraphicState = inheritedGraphicState;
        this.parentStructElem = parentStructElem;
        this.parentsTags = parentsTags;
        this.blendingColorSpace = this.getBlendingColorSpace();
        this.defaultLang = defaultLang;
    }

    @Override
    public String getSubtype2() {
        ASAtom subtype2 = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getSubtype2();
        return subtype2 == null ? null : subtype2.getValue();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "contentStream": {
                return this.getContentStream();
            }
            case "transparencyColorSpace": {
                return this.getTransparencyGroup();
            }
            case "parentTransparencyColorSpace": {
                return this.getParentTransparencyGroup();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDGroup> getGroup() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        return this.groups;
    }

    public PDColorSpace getBlendingColorSpace() {
        PDGroup group = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getGroup();
        if (group == null || !ASAtom.TRANSPARENCY.equals(group.getSubtype())) {
            return null;
        }
        PDColorSpace colorSpace = group.getColorSpace();
        PDColorSpace currentTransparencyColorSpace = StaticContainers.getCurrentTransparencyColorSpace();
        if (currentTransparencyColorSpace == null) {
            return colorSpace;
        }
        if (colorSpace == null) {
            return null;
        }
        if (colorSpace.getType() == ASAtom.DEVICERGB) {
            if (currentTransparencyColorSpace.getType() == ASAtom.CALRGB || currentTransparencyColorSpace.getType() == ASAtom.LAB) {
                return null;
            }
            if (currentTransparencyColorSpace.getType() == ASAtom.ICCBASED && currentTransparencyColorSpace.getNumberOfComponents() == 3) {
                return null;
            }
        } else if (colorSpace.getType() == ASAtom.DEVICECMYK) {
            if (currentTransparencyColorSpace.getType() == ASAtom.ICCBASED && currentTransparencyColorSpace.getNumberOfComponents() == 4) {
                return null;
            }
        } else if (colorSpace.getType() == ASAtom.DEVICEGRAY) {
            if (currentTransparencyColorSpace.getType() == ASAtom.CALGRAY) {
                return null;
            }
            if (currentTransparencyColorSpace.getType() == ASAtom.ICCBASED && currentTransparencyColorSpace.getNumberOfComponents() == 1) {
                return null;
            }
        }
        return colorSpace;
    }

    @Override
    public Boolean getcontainsPS() {
        return this.simplePDObject.knownKey(ASAtom.PS);
    }

    @Override
    public Boolean getcontainsRef() {
        return this.simplePDObject.knownKey(ASAtom.REF);
    }

    @Override
    public Boolean getisUniqueSemanticParent() {
        if (!this.simplePDObject.knownKey(ASAtom.STRUCT_PARENTS)) {
            return true;
        }
        COSKey key = this.simplePDObject.getObject().getKey();
        if (key == null) {
            return true;
        }
        if (StaticContainers.getXFormKeysSet().contains(key)) {
            return false;
        }
        StaticContainers.getXFormKeysSet().add(key);
        return true;
    }

    @Override
    public String getID() {
        return null;
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.contentStreams;
    }

    private void initializeGroups() {
        org.verapdf.pd.images.PDXForm form = (org.verapdf.pd.images.PDXForm)this.simplePDObject;
        PDGroup group = form.getGroup();
        if (group != null) {
            this.groupContainsTransparency = ASAtom.TRANSPARENCY.equals(group.getSubtype());
            ArrayList<GFPDGroup> groups = new ArrayList<GFPDGroup>(1);
            groups.add(new GFPDGroup(group, this.resourcesHandler.getObjectResources()));
            this.groups = Collections.unmodifiableList(groups);
        } else {
            this.groups = Collections.emptyList();
        }
    }

    private void parseContentStream() {
        ArrayList<PDContentStream> streams = new ArrayList<PDContentStream>(1);
        GFPDContentStream gfContentStream = !PDFAFlavour.IsoStandardSeries.ISO_14289.equals((Object)StaticContainers.getFlavour().getPart().getSeries()) && !PDFAFlavour.WCAG2_1.getPart().getFamily().equals(StaticContainers.getFlavour().getPart().getFamily()) ? new GFPDContentStream((org.verapdf.pd.images.PDXForm)this.simplePDObject, this.resourcesHandler, this.inheritedGraphicState, new StructureElementAccessObject(this.simpleCOSObject), this.parentStructElem, this.parentsTags) : new GFPDSemanticContentStream((org.verapdf.pd.images.PDXForm)this.simplePDObject, this.resourcesHandler, this.inheritedGraphicState, new StructureElementAccessObject(this.simpleCOSObject), this.parentStructElem, this.parentsTags, this.defaultLang);
        this.contentStreamContainsTransparency = gfContentStream.isContainsTransparency();
        streams.add(gfContentStream);
        this.contentStreams = streams;
    }

    public boolean containsTransparency() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.groupContainsTransparency || this.contentStreamContainsTransparency;
    }

    private List<TransparencyColorSpace> getTransparencyGroup() {
        if (this.blendingColorSpace != null) {
            ArrayList<GFTransparencyColorSpace> xFormTransparencyGroup = new ArrayList<GFTransparencyColorSpace>(1);
            xFormTransparencyGroup.add(new GFTransparencyColorSpace(this.blendingColorSpace));
            return Collections.unmodifiableList(xFormTransparencyGroup);
        }
        return Collections.emptyList();
    }

    private List<TransparencyColorSpace> getParentTransparencyGroup() {
        if (this.blendingColorSpace != null) {
            ArrayList<GFTransparencyColorSpace> parentXFormTransparencyGroup = new ArrayList<GFTransparencyColorSpace>(1);
            parentXFormTransparencyGroup.add(new GFTransparencyColorSpace(StaticContainers.getCurrentTransparencyColorSpace()));
            StaticContainers.setCurrentTransparencyColorSpace(this.blendingColorSpace);
            return Collections.unmodifiableList(parentXFormTransparencyGroup);
        }
        return Collections.emptyList();
    }
}

