/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.factory.functions.FunctionFactory;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.gf.model.impl.pd.functions.GFPDFunction;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.pdlayer.PDSeparation;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceN;
import org.verapdf.pd.function.PDFunction;

public class GFPDDeviceN
extends GFPDColorSpace
implements org.verapdf.model.pdlayer.PDDeviceN {
    public static final String DEVICE_N_TYPE = "PDDeviceN";
    public static final String TINT_TRANSFORM = "tintTransform";
    public static final String ALTERNATE = "alternate";
    public static final String COLORANT_NAMES = "colorantNames";
    public static final String COLORANTS = "Colorants";
    public static final String PROCESS_COLOR = "processColor";
    public static final Set<ASAtom> IGNORED_COLORANTS;
    private final boolean areColorantsPresent;

    public GFPDDeviceN(PDDeviceN simplePDObject) {
        super(simplePDObject, DEVICE_N_TYPE);
        this.areColorantsPresent = GFPDDeviceN.areColorantsPresent(simplePDObject);
    }

    private static boolean areColorantsPresent(PDDeviceN simplePDObject) {
        COSObject attributes = simplePDObject.getAttributes();
        List<COSObject> colorantsArray = simplePDObject.getNames();
        if (attributes != null && attributes.getType() == COSObjType.COS_DICT) {
            COSArray components;
            COSObject colorantsDict = attributes.getKey(ASAtom.COLORANTS);
            HashSet<ASAtom> componentNames = new HashSet<ASAtom>();
            if (colorantsDict != null && colorantsDict.getType() == COSObjType.COS_DICT) {
                componentNames.addAll(colorantsDict.getKeySet());
            }
            if ((components = GFPDDeviceN.getProcessComponents(attributes)) != null) {
                for (COSObject component : components) {
                    if (component.getType() != COSObjType.COS_NAME) continue;
                    componentNames.add(component.getName());
                }
            }
            return GFPDDeviceN.areColorantsPresent(componentNames, colorantsArray);
        }
        return GFPDDeviceN.areColorantsPresent(Collections.emptySet(), colorantsArray);
    }

    private static COSArray getProcessComponents(COSObject attributes) {
        COSObject components;
        COSObject process = attributes.getKey(ASAtom.PROCESS);
        if (!process.empty() && !(components = process.getKey(ASAtom.COMPONENTS)).empty() && components.getType() == COSObjType.COS_ARRAY) {
            return (COSArray)components.getDirectBase();
        }
        return null;
    }

    private static boolean areColorantsPresent(Set<ASAtom> colorantDictionaryEntries, List<COSObject> colorantsArray) {
        for (COSObject object : colorantsArray) {
            if (object == null || GFPDDeviceN.isNone(object) || IGNORED_COLORANTS.contains(object.getName()) || colorantDictionaryEntries.contains(object.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean isNone(COSObject obj) {
        return obj.getType() == COSObjType.COS_NAME && obj.getName() == ASAtom.NONE;
    }

    @Override
    public Boolean getareColorantsPresent() {
        return this.areColorantsPresent;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "alternate": {
                return this.getAlternate();
            }
            case "colorantNames": {
                return this.getColorantNames();
            }
            case "Colorants": {
                return this.getColorants();
            }
            case "processColor": {
                return this.getProcessColor();
            }
            case "tintTransform": {
                return this.getTintTransform();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getProcessColor() {
        PDColorSpace colorSpace = ((PDDeviceN)this.simplePDObject).getProcessColorSpace();
        if (colorSpace == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ColorSpaceFactory.getColorSpace(colorSpace));
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getAlternate() {
        PDColorSpace alternateColorSpace = ((PDDeviceN)this.simplePDObject).getAlternateSpace();
        org.verapdf.model.pdlayer.PDColorSpace space = ColorSpaceFactory.getColorSpace(alternateColorSpace);
        if (space != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpace = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpace.add(space);
            return Collections.unmodifiableList(colorSpace);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getColorantNames() {
        List<COSObject> colorants = ((PDDeviceN)this.simplePDObject).getNames();
        if (!colorants.isEmpty()) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(colorants.size());
            for (COSObject colorant : colorants) {
                if (colorant.getType() != COSObjType.COS_NAME) continue;
                list.add(new GFCosUnicodeName((COSName)colorant.getDirectBase()));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PDSeparation> getColorants() {
        LinkedList<PDSeparation> result = new LinkedList<PDSeparation>();
        List<PDColorSpace> colorants = ((PDDeviceN)this.simplePDObject).getColorants();
        for (PDColorSpace colorSpace : colorants) {
            if (!ASAtom.SEPARATION.equals(colorSpace.getType())) continue;
            result.add((GFPDSeparation)ColorSpaceFactory.getColorSpace(colorSpace));
        }
        return result;
    }

    private List<GFPDFunction> getTintTransform() {
        PDFunction pdFunction = ((PDDeviceN)this.simplePDObject).getTintTransform();
        if (pdFunction == null) {
            return Collections.emptyList();
        }
        GFPDFunction gfpdFunction = FunctionFactory.createFunction(pdFunction);
        return Collections.singletonList(gfpdFunction);
    }

    static {
        HashSet<ASAtom> tempIgnore = new HashSet<ASAtom>();
        tempIgnore.add(ASAtom.getASAtom("Cyan"));
        tempIgnore.add(ASAtom.getASAtom("Magenta"));
        tempIgnore.add(ASAtom.getASAtom("Yellow"));
        tempIgnore.add(ASAtom.getASAtom("Black"));
        IGNORED_COLORANTS = Collections.unmodifiableSet(tempIgnore);
    }
}

