/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.parser.SeekableCOSParser;

public class DecodedObjectStreamParser
extends SeekableCOSParser {
    private final COSStream objectStream;
    private final Map<Integer, Long> internalOffsets;

    public DecodedObjectStreamParser(ASInputStream inputStream, COSStream objectStream, COSKey streamKey, COSDocument doc) throws IOException {
        super(doc, inputStream);
        this.objectStream = objectStream;
        this.internalOffsets = new HashMap<Integer, Long>();
        this.keyOfCurrentObject = streamKey;
        try {
            this.calculateInternalOffsets();
        }
        catch (Exception e) {
            throw new IOException(this.getErrorMessage("Object stream has invalid N or First entry"), e);
        }
    }

    private void calculateInternalOffsets() throws IOException {
        int n = (int)((COSInteger)this.objectStream.getKey(ASAtom.N).getDirectBase()).get();
        long first = ((COSInteger)this.objectStream.getKey(ASAtom.FIRST).getDirectBase()).get();
        for (int i = 0; i < n; ++i) {
            this.getBaseParser().skipSpaces(false);
            this.getBaseParser().readNumber();
            long objNum = this.getBaseParser().getToken().integer;
            this.getBaseParser().skipSpaces(false);
            this.getBaseParser().readNumber();
            long objOffset = this.getBaseParser().getToken().integer;
            this.internalOffsets.put((int)objNum, objOffset + first);
        }
    }

    public boolean containsObject(int objNum) {
        return this.internalOffsets.containsKey(objNum);
    }

    public List<COSKey> getInternalObjectsKeys() {
        ArrayList<COSKey> res = new ArrayList<COSKey>();
        for (Map.Entry<Integer, Long> entry : this.internalOffsets.entrySet()) {
            res.add(new COSKey(entry.getKey(), 0));
        }
        return res;
    }

    public COSObject getObject(COSKey key) throws IOException {
        int objNum = key.getNumber();
        if (!this.internalOffsets.containsKey(objNum)) {
            return new COSObject();
        }
        this.getSource().seek(this.internalOffsets.get(objNum));
        this.flag = true;
        this.objects.clear();
        this.integers.clear();
        this.keyOfCurrentObject = key;
        COSObject res = this.nextObject();
        res.setObjectKey(key);
        return res;
    }
}

