/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.ChooseFlavourRenderer;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.processor.app.ConfigManager;
import org.verapdf.processor.app.VeraAppConfig;

class SettingsPanel
extends JPanel {
    private static final char[] FORBIDDEN_SYMBOLS_IN_FILE_NAME = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '+', '\u0000', '%'};
    private static final long serialVersionUID = -5688021756073449469L;
    private final JButton okButton;
    boolean ok;
    JDialog dialog;
    private final JTextField numberOfFailed;
    private final JTextField numberOfFailedDisplay;
    private final JCheckBox hidePassedRules;
    private final JCheckBox logs;
    private final JCheckBox showErrorMessages;
    private final JTextField fixMetadataPrefix;
    private PDFAFlavour currentDefaultFlavour;
    JTextField fixMetadataFolder;
    JFileChooser folderChooser;
    private final JTextField profilesWikiPath;
    private static final Map<String, PDFAFlavour> FLAVOURS_MAP = new HashMap<String, PDFAFlavour>();
    private static final Map<String, Integer> LOGGING_LEVELS_MAP = new HashMap<String, Integer>();
    private final JComboBox<String> chooseDefaultFlavour;
    private final JComboBox<String> chooseLoggingLevel;

    SettingsPanel(ConfigManager config) throws IOException {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(7, 2));
        panel.add(new JLabel("Include passed checks:"));
        this.hidePassedRules = new JCheckBox();
        panel.add(this.hidePassedRules);
        panel.add(new JLabel("Add logs to xml and html reports:"));
        this.logs = new JCheckBox();
        panel.add(this.logs);
        panel.add(new JLabel("Add detailed errors to report:"));
        this.showErrorMessages = new JCheckBox();
        panel.add(this.showErrorMessages);
        panel.add(new JLabel("Halt execution after deviations:"));
        this.numberOfFailed = new JTextField();
        this.numberOfFailed.setTransferHandler(null);
        this.numberOfFailed.addKeyListener(SettingsPanel.getKeyAdapter(this.numberOfFailed, false));
        this.numberOfFailed.setToolTipText("1 to 999999 or empty for unlimited");
        JPanel panel1 = new JPanel();
        panel1.setLayout(null);
        this.numberOfFailed.setBounds(0, 0, 65, 28);
        panel1.add(this.numberOfFailed);
        panel.add(panel1);
        panel.add(new JLabel("Display deviations for rule: "));
        this.numberOfFailedDisplay = new JTextField();
        this.numberOfFailedDisplay.setTransferHandler(null);
        this.numberOfFailedDisplay.addKeyListener(SettingsPanel.getKeyAdapter(this.numberOfFailedDisplay, false));
        this.numberOfFailedDisplay.setToolTipText("1 to 999999 or empty for unlimited");
        JPanel panel2 = new JPanel();
        panel2.setLayout(null);
        this.numberOfFailedDisplay.setBounds(0, 0, 65, 28);
        panel2.add(this.numberOfFailedDisplay);
        panel.add(panel2);
        this.fixMetadataPrefix = new JTextField(19);
        JButton choose2 = new JButton("Choose");
        this.folderChooser = new JFileChooser();
        File currentDir = new File(new File(".").getCanonicalPath());
        this.folderChooser.setCurrentDirectory(currentDir);
        this.folderChooser.setFileSelectionMode(1);
        choose2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resultChoose = SettingsPanel.this.folderChooser.showOpenDialog(SettingsPanel.this);
                if (resultChoose == 0) {
                    if (!SettingsPanel.this.folderChooser.getSelectedFile().isDirectory()) {
                        JOptionPane.showMessageDialog(SettingsPanel.this, "Error. Selected directory doesn't exist.", "Error", 0);
                    } else {
                        SettingsPanel.this.fixMetadataFolder.setText(SettingsPanel.this.folderChooser.getSelectedFile().getAbsolutePath());
                    }
                }
            }
        });
        this.fixMetadataFolder = new JTextField(19);
        this.fixMetadataFolder.setToolTipText("Select a folder for saving repaired files to. If not set then they'll be saved next to the original.");
        this.fixMetadataPrefix.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!SettingsPanel.isValidFileNameCharacter(e.getKeyChar())) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
            }
        });
        this.profilesWikiPath = new JTextField(19);
        panel.add(new JLabel("Default PDF flavour:"));
        TreeSet<String> sortedFlavours = new TreeSet<String>();
        for (PDFAFlavour flavour : Profiles.getVeraProfileDirectory().getPDFAFlavours()) {
            String flavourReadableText = CheckerPanel.getFlavourReadableText(flavour);
            sortedFlavours.add(flavourReadableText);
            FLAVOURS_MAP.put(flavourReadableText, flavour);
        }
        Vector availableFlavours = new Vector(sortedFlavours);
        this.chooseDefaultFlavour = new JComboBox(availableFlavours);
        this.chooseDefaultFlavour.setOpaque(true);
        ChooseFlavourRenderer renderer = new ChooseFlavourRenderer();
        this.chooseDefaultFlavour.setRenderer(renderer);
        PDFAFlavour fromConfig = config.getValidatorConfig().getDefaultFlavour();
        String fromConfigDefaultFlavourText = CheckerPanel.getFlavourReadableText(fromConfig);
        if (availableFlavours.contains(fromConfigDefaultFlavourText)) {
            this.chooseDefaultFlavour.setSelectedItem(fromConfigDefaultFlavourText);
            this.currentDefaultFlavour = fromConfig;
        } else {
            this.chooseDefaultFlavour.setSelectedItem(CheckerPanel.getFlavourReadableText(PDFAFlavour.ARLINGTON1_4));
            this.currentDefaultFlavour = PDFAFlavour.ARLINGTON1_4;
        }
        panel.add(this.chooseDefaultFlavour);
        panel.add(new JLabel("Logging level:   "));
        Vector<String> availableLoggingLevels = new Vector<String>();
        availableLoggingLevels.add("OFF");
        availableLoggingLevels.add("SEVERE");
        availableLoggingLevels.add("WARNING, SEVERE");
        availableLoggingLevels.add("CONFIG, INFO, WARNING, SEVERE");
        availableLoggingLevels.add("ALL");
        for (int i = 0; i < availableLoggingLevels.size(); ++i) {
            LOGGING_LEVELS_MAP.put((String)availableLoggingLevels.get(i), i);
        }
        this.chooseLoggingLevel = new JComboBox(availableLoggingLevels);
        this.chooseLoggingLevel.setOpaque(true);
        this.chooseLoggingLevel.setRenderer(new ChooseFlavourRenderer());
        String levelFromConfig = LOGGING_LEVELS_MAP.keySet().stream().filter(l -> l.startsWith(config.getValidatorConfig().getLoggingLevel().toString())).findFirst().orElse("WARNING, SEVERE");
        this.chooseLoggingLevel.setSelectedItem(levelFromConfig);
        panel.add(this.chooseLoggingLevel);
        this.add((Component)panel, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedItem = (String)SettingsPanel.this.chooseDefaultFlavour.getSelectedItem();
                SettingsPanel.this.currentDefaultFlavour = (PDFAFlavour)FLAVOURS_MAP.get(selectedItem);
                boolean isEverythingValid = true;
                Path mdPath = FileSystems.getDefault().getPath(SettingsPanel.this.fixMetadataFolder.getText(), new String[0]);
                if (!(mdPath != null && (mdPath.toString().isEmpty() || mdPath.toFile().isDirectory() && mdPath.toFile().canWrite()))) {
                    isEverythingValid = false;
                    JOptionPane.showMessageDialog(SettingsPanel.this, "Invalid path for saving fixed files.", "Invalid data", 1);
                }
                if (isEverythingValid) {
                    SettingsPanel.this.ok = true;
                    SettingsPanel.this.dialog.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SettingsPanel.this.dialog.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    boolean showDialog(Component parent, String title, ConfigManager settings) {
        this.ok = false;
        ValidatorConfig validatorConfig = settings.getValidatorConfig();
        this.hidePassedRules.setSelected(validatorConfig.isRecordPasses());
        this.showErrorMessages.setSelected(validatorConfig.showErrorMessages());
        this.logs.setSelected(validatorConfig.isLogsEnabled());
        int numbOfFail = validatorConfig.getMaxFails();
        if (numbOfFail == -1) {
            this.numberOfFailed.setText("");
        } else {
            this.numberOfFailed.setText(String.valueOf(numbOfFail));
        }
        int numbOfFailDisp = validatorConfig.getMaxNumberOfDisplayedFailedChecks();
        if (numbOfFailDisp == -1) {
            this.numberOfFailedDisplay.setText("");
        } else {
            this.numberOfFailedDisplay.setText(String.valueOf(numbOfFailDisp));
        }
        String defaultLevel = LOGGING_LEVELS_MAP.keySet().stream().filter(l -> l.startsWith(validatorConfig.getLoggingLevel().toString())).findFirst().orElse("WARNING, SEVERE");
        this.chooseLoggingLevel.setSelectedItem(defaultLevel);
        PDFAFlavour defaultFlavour = validatorConfig.getDefaultFlavour();
        String fromConfigDefaultFlavourText = CheckerPanel.getFlavourReadableText(defaultFlavour);
        this.chooseDefaultFlavour.setSelectedItem(fromConfigDefaultFlavourText);
        this.fixMetadataPrefix.setText(settings.getFixerConfig().getFixesPrefix());
        VeraAppConfig appConfig = settings.getApplicationConfig();
        this.fixMetadataFolder.setText(appConfig.getFixesFolder());
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle(title);
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
        return this.ok;
    }

    public PDFAFlavour getCurrentDefaultFlavour() {
        return this.currentDefaultFlavour;
    }

    private static KeyAdapter getKeyAdapter(final JTextField field, final boolean fromZero) {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (field.getText().length() == 6 && (field.getSelectedText() == null || field.getSelectedText().isEmpty()) && c != '\b' && c != '\u007f') {
                    e.consume();
                } else if (c == '0' && (!fromZero && field.getText().isEmpty() || field.getText().startsWith("0"))) {
                    e.consume();
                } else if ((c < '0' || c > '9') && c != '\b' && c != '\u007f') {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (field.getText().startsWith("0")) {
                    field.setText(field.getText().replaceFirst("0*", ""));
                    if (field.getText().isEmpty()) {
                        if (fromZero) {
                            field.setText("0");
                        } else {
                            field.setText("");
                        }
                    }
                }
                super.keyReleased(e);
            }
        };
    }

    boolean isDispPassedRules() {
        return this.hidePassedRules.isSelected();
    }

    boolean isLogsEnabled() {
        return this.logs.isSelected();
    }

    boolean showErrorMessages() {
        return this.showErrorMessages.isSelected();
    }

    Level getLoggingLevel() {
        return Level.parse(((String)this.chooseLoggingLevel.getSelectedItem()).split(",")[0]);
    }

    int getFailedChecksNumber() {
        String str = this.numberOfFailed.getText();
        return !str.isEmpty() ? Integer.parseInt(str) : -1;
    }

    int getFailedChecksDisplayNumber() {
        String str = this.numberOfFailedDisplay.getText();
        return !str.isEmpty() ? Integer.parseInt(str) : -1;
    }

    Path getFixMetadataDirectory() {
        return FileSystems.getDefault().getPath(this.fixMetadataFolder.getText(), new String[0]);
    }

    String getFixMetadataPrefix() {
        return this.fixMetadataPrefix.getText();
    }

    String getProfilesWikiPath() {
        return this.profilesWikiPath.getText();
    }

    public static final boolean isValidFileNameCharacter(char c) {
        for (char ch : FORBIDDEN_SYMBOLS_IN_FILE_NAME) {
            if (ch != c) continue;
            return false;
        }
        return true;
    }
}

