/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import org.verapdf.core.utils.FileUtils;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesStructureContainer;
import org.verapdf.policy.SchematronGenerator;
import org.verapdf.policy.SchematronOperation;

public class PolicyPanel
extends JPanel {
    private static final long serialVersionUID = 4654611715077095480L;
    private static final String ERROR_IDS = "Error IDs";
    private File policyFile;
    private final JButton okButton;
    private JDialog dialog;
    private boolean ok;
    private final JPanel mainPanel;
    private final JPanel assertionsPanel;
    private final LayoutManager mainPanelLayout;
    private final JScrollPane scrollPane;
    private final List<JComboBox<FeatureObjectType>> featureTypes;
    private final List<JTextField> arguments;
    private final List<JComboBox<Feature>> features;
    private final List<JComboBox<SchematronOperation>> operations;
    private final List<JButton> removeLineButtons;
    private final List<JPanel> layoutPanels;
    private final JPanel buttonPanel;
    private final JButton addLineButton;

    public PolicyPanel() {
        this.setPreferredSize(new Dimension(850, 250));
        this.featureTypes = new LinkedList<JComboBox<FeatureObjectType>>();
        this.arguments = new LinkedList<JTextField>();
        this.features = new LinkedList<JComboBox<Feature>>();
        this.operations = new LinkedList<JComboBox<SchematronOperation>>();
        this.removeLineButtons = new LinkedList<JButton>();
        this.layoutPanels = new LinkedList<JPanel>();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PolicyPanel.this.okButton.hasFocus()) {
                    JTextField emptyArguments = PolicyPanel.this.findEmptyNumberArguments();
                    if (emptyArguments == null) {
                        if (!PolicyPanel.this.layoutPanels.isEmpty()) {
                            PolicyPanel.this.ok = true;
                        }
                        PolicyPanel.this.dialog.setVisible(false);
                    } else {
                        emptyArguments.requestFocus();
                        PolicyPanel.this.showErrorMessage("Argument required");
                    }
                }
            }
        });
        final JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (cancelButton.hasFocus()) {
                    PolicyPanel.this.dialog.setVisible(false);
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel okButtonPanel = new JPanel();
        okButtonPanel.add(this.okButton);
        okButtonPanel.add(cancelButton);
        this.add((Component)okButtonPanel, "South");
        this.addLineButton = new JButton("+");
        this.addLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyPanel.this.addLineToMainPanel();
            }
        });
        this.addLineButton.setPreferredSize(new Dimension(42, 25));
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.buttonPanel.add(this.addLineButton);
        this.assertionsPanel = new JPanel();
        this.mainPanelLayout = new BoxLayout(this.assertionsPanel, 1);
        this.assertionsPanel.setLayout(this.mainPanelLayout);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.mainPanel.add((Component)this.assertionsPanel, "North");
        this.scrollPane = new JScrollPane(this.mainPanel);
        this.add((Component)this.scrollPane, "Center");
    }

    public boolean showDialog(Component parent) {
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        this.ok = false;
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle("Policy Creator");
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
        this.dialog.repaint();
        return this.ok;
    }

    public File getPolicyFile() {
        return this.policyFile;
    }

    public void writeSchematronFile() throws IOException, XMLStreamException {
        try (FileOutputStream outputStream = new FileOutputStream(this.policyFile);){
            SchematronGenerator.writeSchematron(this.getAssertions(), (OutputStream)outputStream);
        }
    }

    public void setPolicyFile(File candidate) {
        this.policyFile = FileUtils.hasExtNoCase((String)candidate.getName(), (String)"sch") ? candidate : new File(candidate.getParentFile(), FileUtils.addExt((String)candidate.getName(), (String)"sch"));
    }

    public List<SchematronGenerator.Assertion> getAssertions() {
        ArrayList<SchematronGenerator.Assertion> res = new ArrayList<SchematronGenerator.Assertion>(this.featureTypes.size());
        for (int i = 0; i < this.featureTypes.size(); ++i) {
            FeatureObjectType assertionType = (FeatureObjectType)this.featureTypes.get(i).getSelectedItem();
            Feature assertionFeature = (Feature)this.features.get(i).getSelectedItem();
            SchematronOperation assertionOperation = (SchematronOperation)this.operations.get(i).getSelectedItem();
            JTextField argumentTextField = this.arguments.get(i);
            String assertionArgument = argumentTextField.isEditable() ? argumentTextField.getText() : "";
            res.add(new SchematronGenerator.Assertion(assertionType, assertionFeature, assertionOperation, assertionArgument));
        }
        return res;
    }

    private void addLineToMainPanel() {
        JPanel linePanel = new JPanel();
        GridBagLayout linePanelLayout = new GridBagLayout();
        linePanel.setLayout(linePanelLayout);
        JTextField argumentsTextField = new JTextField(10);
        this.arguments.add(argumentsTextField);
        argumentsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField textField = (JTextField)e.getSource();
                int index = PolicyPanel.this.arguments.indexOf(textField);
                Feature feature = (Feature)((JComboBox)PolicyPanel.this.features.get(index)).getSelectedItem();
                PolicyPanel.this.validateArgumentTextBox(textField, feature.getFeatureType());
            }
        });
        JComboBox<FeatureObjectType> featuresTypeComboBox = this.getFeatureTypeComboBox();
        this.featureTypes.add(featuresTypeComboBox);
        linePanelLayout.setConstraints(featuresTypeComboBox, PolicyPanel.getFeatureObjectTypeConstraints());
        linePanel.add(featuresTypeComboBox);
        JComboBox<Feature> featuresComboBox = this.getFeatureComboBox(featuresTypeComboBox);
        this.features.add(featuresComboBox);
        linePanelLayout.setConstraints(featuresComboBox, PolicyPanel.getFeatureConstraints());
        linePanel.add(featuresComboBox);
        JComboBox<SchematronOperation> operationsComboBox = this.getOperationsComboBox(featuresComboBox);
        this.operations.add(operationsComboBox);
        linePanelLayout.setConstraints(operationsComboBox, PolicyPanel.getOperationConstraints());
        linePanel.add(operationsComboBox);
        PolicyPanel.setAvailabilityForArgumentTextBox(argumentsTextField, (SchematronOperation)operationsComboBox.getSelectedItem());
        linePanelLayout.setConstraints(argumentsTextField, PolicyPanel.getArgumentConstraints());
        linePanel.add(argumentsTextField);
        JButton removeButton = new JButton("x");
        removeButton.setPreferredSize(new Dimension(42, 25));
        removeButton.addActionListener(new RemoveLineButtonListener());
        this.removeLineButtons.add(removeButton);
        linePanelLayout.setConstraints(removeButton, PolicyPanel.getButtonConstraints());
        linePanel.add(removeButton);
        this.layoutPanels.add(linePanel);
        this.assertionsPanel.add(linePanel);
        this.dialog.revalidate();
        this.dialog.repaint();
        JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    private void removeLineFromMainPanel(int index) {
        if (index >= 0 && index < this.layoutPanels.size()) {
            this.assertionsPanel.remove(index);
            this.featureTypes.remove(index);
            this.features.remove(index);
            this.operations.remove(index);
            this.arguments.remove(index);
            this.removeLineButtons.remove(index);
            this.layoutPanels.remove(index);
            this.dialog.revalidate();
            this.dialog.repaint();
        }
    }

    private JComboBox<FeatureObjectType> getFeatureTypeComboBox() {
        JComboBox<FeatureObjectType> featuresTypeComboBox = new JComboBox<FeatureObjectType>(PolicyPanel.getFeatureObjectTypes());
        featuresTypeComboBox.setRenderer(new FeatureObjectTypeRenderer());
        featuresTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItemSelectable() instanceof JComboBox) {
                    int index = PolicyPanel.this.featureTypes.indexOf(e.getItemSelectable());
                    PolicyPanel.setFeaturesComboBoxForFeature((JComboBox)PolicyPanel.this.features.get(index), (FeatureObjectType)e.getItem());
                }
            }
        });
        PolicyPanel.setOptimalSizeForComboBox(featuresTypeComboBox);
        return featuresTypeComboBox;
    }

    private JComboBox<Feature> getFeatureComboBox(JComboBox<FeatureObjectType> featuresTypeComboBox) {
        JComboBox<Feature> featuresComboBox = new JComboBox<Feature>();
        PolicyPanel.setFeaturesComboBoxForFeature(featuresComboBox, (FeatureObjectType)featuresTypeComboBox.getSelectedItem());
        featuresComboBox.setRenderer(new FeatureRenderer());
        featuresComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItemSelectable() instanceof JComboBox) {
                    int index = PolicyPanel.this.features.indexOf(e.getItemSelectable());
                    PolicyPanel.setOperationsComboBoxForFeatureType((JComboBox)PolicyPanel.this.operations.get(index), (Feature)e.getItem());
                }
            }
        });
        PolicyPanel.setOptimalSizeForComboBox(featuresComboBox);
        return featuresComboBox;
    }

    private JComboBox<SchematronOperation> getOperationsComboBox(JComboBox<Feature> featuresComboBox) {
        JComboBox<SchematronOperation> operationsComboBox = new JComboBox<SchematronOperation>();
        operationsComboBox.setRenderer(new OperationsRenderer());
        PolicyPanel.setOperationsComboBoxForFeatureType(operationsComboBox, (Feature)featuresComboBox.getSelectedItem());
        operationsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItemSelectable() instanceof JComboBox) {
                    JComboBox comboBox = (JComboBox)e.getItemSelectable();
                    int index = PolicyPanel.this.operations.indexOf(comboBox);
                    SchematronOperation operation = (SchematronOperation)comboBox.getSelectedItem();
                    PolicyPanel.setAvailabilityForArgumentTextBox((JTextField)PolicyPanel.this.arguments.get(index), operation);
                }
            }
        });
        PolicyPanel.setOptimalSizeForComboBox(operationsComboBox);
        return operationsComboBox;
    }

    private static void setFeaturesComboBoxForFeature(JComboBox<Feature> comboBox, FeatureObjectType type) {
        List features = FeaturesStructureContainer.getFeaturesListForType((FeatureObjectType)type);
        comboBox.removeAllItems();
        for (Feature feature : features) {
            if (feature.getFeatureName().equals(ERROR_IDS)) continue;
            comboBox.addItem(feature);
        }
    }

    private static void setOperationsComboBoxForFeatureType(JComboBox<SchematronOperation> comboBox, Feature type) {
        EnumSet operations = type.getFeatureType().getLegalOperations();
        comboBox.removeAllItems();
        for (SchematronOperation operation : operations) {
            comboBox.addItem(operation);
        }
    }

    private static void setAvailabilityForArgumentTextBox(JTextField argument, SchematronOperation operation) {
        if (operation != null) {
            argument.setEditable(operation.hasArguments());
            argument.setEnabled(operation.hasArguments());
        }
    }

    private boolean validateArgumentTextBox(JTextField argument, Feature.FeatureType type) {
        if (type == Feature.FeatureType.NUMBER) {
            String argumentValue = argument.getText();
            try {
                if (!argumentValue.isEmpty()) {
                    Double.valueOf(argumentValue);
                }
            }
            catch (NumberFormatException e) {
                this.showErrorMessage("Please enter a valid number");
                argument.requestFocus();
                return false;
            }
        }
        return true;
    }

    private JTextField findEmptyNumberArguments() {
        for (JTextField textField : this.arguments) {
            int index = this.arguments.indexOf(textField);
            Feature.FeatureType argType = ((Feature)this.features.get(index).getSelectedItem()).getFeatureType();
            if (!textField.isEnabled() || !textField.getText().isEmpty() || argType == Feature.FeatureType.STRING) continue;
            return textField;
        }
        return null;
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private static Vector<FeatureObjectType> getFeatureObjectTypes() {
        Vector<FeatureObjectType> res = new Vector<FeatureObjectType>();
        for (FeatureObjectType type : FeatureObjectType.values()) {
            List features = FeaturesStructureContainer.getFeaturesListForType((FeatureObjectType)type);
            if (features.size() == 1 && ((Feature)features.get(0)).getFeatureName().equals(ERROR_IDS) || features.isEmpty()) continue;
            res.add(type);
        }
        return res;
    }

    private static GridBagConstraints getFeatureObjectTypeConstraints() {
        GridBagConstraints res = new GridBagConstraints();
        res.gridheight = 1;
        res.gridwidth = 1;
        res.gridx = 0;
        res.gridy = 0;
        res.weighty = 0.0;
        res.weightx = 2.0;
        res.fill = 0;
        res.insets = PolicyPanel.getDefaultInsets();
        return res;
    }

    private static GridBagConstraints getFeatureConstraints() {
        GridBagConstraints res = new GridBagConstraints();
        res.gridheight = 1;
        res.gridwidth = 1;
        res.gridx = 1;
        res.gridy = 0;
        res.weighty = 0.0;
        res.weightx = 2.0;
        res.fill = 0;
        res.insets = PolicyPanel.getDefaultInsets();
        return res;
    }

    private static GridBagConstraints getOperationConstraints() {
        GridBagConstraints res = new GridBagConstraints();
        res.gridheight = 1;
        res.gridwidth = 1;
        res.gridx = 2;
        res.gridy = 0;
        res.weighty = 0.0;
        res.weightx = 2.0;
        res.fill = 0;
        res.insets = PolicyPanel.getDefaultInsets();
        return res;
    }

    private static GridBagConstraints getArgumentConstraints() {
        GridBagConstraints res = new GridBagConstraints();
        res.gridheight = 1;
        res.gridwidth = 1;
        res.gridx = 3;
        res.gridy = 0;
        res.weighty = 0.0;
        res.weightx = 6.0;
        res.fill = 2;
        res.insets = PolicyPanel.getDefaultInsets();
        return res;
    }

    private static GridBagConstraints getButtonConstraints() {
        GridBagConstraints res = new GridBagConstraints();
        res.gridheight = 1;
        res.gridwidth = 1;
        res.gridx = 4;
        res.gridy = 0;
        res.weighty = 0.0;
        res.weightx = 1.0;
        res.fill = 2;
        res.insets = PolicyPanel.getDefaultInsets();
        return res;
    }

    private static Insets getDefaultInsets() {
        return new Insets(2, 2, 2, 2);
    }

    private static void setOptimalSizeForComboBox(Component component) {
        component.setMinimumSize(new Dimension(212, 25));
        component.setPreferredSize(new Dimension(212, 25));
        component.setMaximumSize(new Dimension(212, 25));
    }

    private class RemoveLineButtonListener
    implements ActionListener {
        private RemoveLineButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PolicyPanel.this.removeLineButtons.indexOf(e.getSource());
            PolicyPanel.this.removeLineFromMainPanel(index);
        }
    }

    private static class FeatureObjectTypeRenderer
    extends JLabel
    implements ListCellRenderer<FeatureObjectType> {
        private static final long serialVersionUID = -8167306132255766422L;

        private FeatureObjectTypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends FeatureObjectType> list, FeatureObjectType value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setText(value.getFullName());
                this.setHorizontalAlignment(0);
                this.setVerticalAlignment(0);
            }
            return this;
        }
    }

    private static class FeatureRenderer
    extends JLabel
    implements ListCellRenderer<Feature> {
        private static final long serialVersionUID = 1669321048267902682L;

        private FeatureRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Feature> list, Feature value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setText(value.getFeatureName());
                this.setHorizontalAlignment(0);
                this.setVerticalAlignment(0);
            }
            return this;
        }
    }

    private static class OperationsRenderer
    extends JLabel
    implements ListCellRenderer<SchematronOperation> {
        private static final long serialVersionUID = 8259625674253427340L;

        private OperationsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SchematronOperation> list, SchematronOperation value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setText(value.getDescription());
                this.setHorizontalAlignment(0);
                this.setVerticalAlignment(0);
            }
            return this;
        }
    }
}

