/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.multithread;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.apps.Applications;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.cli.multithread.BaseCliRunner;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.MultiThreadProcessingHandler;
import org.verapdf.processor.reports.multithread.MultiThreadProcessingHandlerImpl;
import org.verapdf.processor.reports.multithread.writer.ReportWriter;

public class MultiThreadProcessor {
    private static final Logger LOGGER = Logger.getLogger(MultiThreadProcessor.class.getCanonicalName());
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final int COEFFICIENT_BUFFER_SIZE = 1024;
    private final Queue<File> filesToProcess;
    private int filesQuantity;
    private File veraPDFStarterPath;
    private List<String> veraPDFParameters;
    private OutputStream os;
    private OutputStream errorStream;
    private ReportWriter reportWriter;
    private MultiThreadProcessingHandler processingHandler;
    private boolean isFirstReport = true;
    private CliConstants.ExitCodes currentExitCode = CliConstants.ExitCodes.VALID;
    private CountDownLatch latch;

    private MultiThreadProcessor(VeraCliArgParser cliArgParser) {
        this.os = new BufferedOutputStream(System.out, 524288);
        this.errorStream = new BufferedOutputStream(System.err, 512);
        this.veraPDFStarterPath = this.getVeraPdfStarterFile(cliArgParser);
        this.veraPDFParameters = VeraCliArgParser.getBaseVeraPDFParameters(cliArgParser);
        this.filesToProcess = new ConcurrentLinkedQueue<File>();
        this.filesToProcess.addAll(this.getFiles(cliArgParser.getPdfPaths(), cliArgParser.isRecurse()));
        this.filesQuantity = this.filesToProcess.size();
        FormatOption outputFormat = this.getOutputFormat(cliArgParser.getFormat().getOption());
        this.reportWriter = ReportWriter.newInstance((OutputStream)this.os, (FormatOption)outputFormat, (OutputStream)this.errorStream);
        this.processingHandler = new MultiThreadProcessingHandlerImpl(this.reportWriter);
    }

    public static CliConstants.ExitCodes process(VeraCliArgParser cliArgParser) throws InterruptedException {
        MultiThreadProcessor processor = new MultiThreadProcessor(cliArgParser);
        if (processor.currentExitCode != CliConstants.ExitCodes.VALID) {
            return processor.currentExitCode;
        }
        return processor.startProcesses(cliArgParser.getNumberOfProcesses());
    }

    private File getVeraPdfStarterFile(VeraCliArgParser cliArgParser) {
        File veraPDFPath = cliArgParser.getVeraCLIPath();
        if (veraPDFPath == null || !veraPDFPath.isFile()) {
            try {
                veraPDFPath = Applications.getVeraScriptFile();
                if (veraPDFPath == null) {
                    throw new IllegalStateException("Can't obtain executable veraPDF CLI script path");
                }
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.SEVERE, "Can't obtain veraPDF CLI script path", e);
                this.currentExitCode = CliConstants.ExitCodes.FAILED_MULTIPROCESS_START;
            }
        }
        return veraPDFPath;
    }

    private FormatOption getOutputFormat(String outputFormat) {
        return FormatOption.fromOption((String)outputFormat);
    }

    public synchronized void write(ResultStructure result) {
        if (this.isFirstReport) {
            this.processingHandler.startReport();
            this.processingHandler.fillReport(result);
            this.isFirstReport = false;
        } else {
            this.processingHandler.fillReport(result);
        }
        --this.filesQuantity;
        if (this.filesQuantity == 0) {
            this.processingHandler.endReport();
        }
    }

    private List<File> getFiles(List<String> pdfPaths, boolean isRecurse) {
        ArrayList<File> toFilter = new ArrayList<File>(pdfPaths.size());
        pdfPaths.forEach(path -> toFilter.add(new File((String)path)));
        return ApplicationUtils.filterPdfFiles(toFilter, isRecurse);
    }

    private CliConstants.ExitCodes startProcesses(int numberOfProcesses) throws InterruptedException {
        int processesQuantity = Math.min(numberOfProcesses, this.filesToProcess.size());
        this.latch = new CountDownLatch(processesQuantity);
        ExecutorService executor = Executors.newFixedThreadPool(processesQuantity);
        for (int i = 0; i < processesQuantity; ++i) {
            BaseCliRunner veraPDFRunner = new BaseCliRunner(this, this.veraPDFStarterPath.getAbsolutePath(), this.veraPDFParameters, this.filesToProcess);
            executor.submit(veraPDFRunner);
        }
        this.latch.await();
        return this.currentExitCode;
    }

    public void countDown(CliConstants.ExitCodes exitCode) {
        if (exitCode != null && exitCode.value > this.currentExitCode.value) {
            this.currentExitCode = exitCode;
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

