/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.core.VeraPDFException;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.HTMLReport;
import org.xml.sax.SAXException;

class ValidateWorker
extends SwingWorker<BatchSummary, Integer> {
    private static final Logger logger = Logger.getLogger(ValidateWorker.class.getCanonicalName());
    private static final String ERROR_IN_OPEN_STREAMS = "Can't open stream from PDF file or can't open stream to temporary XML report file";
    private static final String ERROR_IN_PROCESSING = "Error during the processing";
    private static final String ERROR_IN_CREATING_TEMP_FILE = "Can't create temporary file for XML report";
    private static final String ERROR_IN_OBTAINING_POLICY_FEATURES = "Can't obtain enabled features from policy files";
    private List<File> pdfs;
    private ValidationProfile customProfile;
    private File policy;
    private CheckerPanel parent;
    private ConfigManager configManager;
    private File xmlReport = null;
    private File htmlReport = null;
    private BatchSummary batchSummary = null;

    ValidateWorker(CheckerPanel parent, List<File> pdfs, ConfigManager configManager, ValidationProfile customProfile, File policy) {
        if (pdfs == null) {
            throw new IllegalArgumentException("List of pdf files can not be null");
        }
        this.parent = parent;
        this.pdfs = pdfs;
        this.configManager = configManager;
        this.customProfile = customProfile;
        this.policy = policy;
    }

    @Override
    protected BatchSummary doInBackground() {
        try {
            this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
            this.xmlReport.deleteOnExit();
            this.htmlReport = null;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ERROR_IN_CREATING_TEMP_FILE, e);
            this.parent.handleValidationError("Can't create temporary file for XML report: ", e);
        }
        try (FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            VeraAppConfig veraAppConfig = this.parent.appConfigFromState();
            ProcessType processType = veraAppConfig.getProcessType();
            boolean isPolicy = (processType == ProcessType.POLICY || processType == ProcessType.POLICY_FIX) && this.policy != null;
            EnumSet<TaskType> tasks = processType.getTasks();
            ValidatorConfig validatorConfig = this.configManager.getValidatorConfig();
            FeatureExtractorConfig featuresConfig = this.configManager.getFeaturesConfig();
            if (isPolicy) {
                try (FileInputStream policyStream = new FileInputStream(this.policy);){
                    featuresConfig = ApplicationUtils.mergeEnabledFeaturesFromPolicy(featuresConfig, policyStream);
                }
                catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                    logger.log(Level.SEVERE, ERROR_IN_OBTAINING_POLICY_FEATURES, e);
                    this.parent.handleValidationError("Can't obtain enabled features from policy files: ", e);
                }
            }
            ProcessorConfig resultConfig = this.customProfile == null ? ProcessorFactory.fromValues((ValidatorConfig)validatorConfig, (FeatureExtractorConfig)featuresConfig, (PluginsCollectionConfig)this.configManager.getPluginsCollectionConfig(), (MetadataFixerConfig)this.configManager.getFixerConfig(), tasks, (String)veraAppConfig.getFixesFolder()) : ProcessorFactory.fromValues((ValidatorConfig)validatorConfig, (FeatureExtractorConfig)featuresConfig, (PluginsCollectionConfig)this.configManager.getPluginsCollectionConfig(), (MetadataFixerConfig)this.configManager.getFixerConfig(), tasks, (ValidationProfile)this.customProfile, (String)veraAppConfig.getFixesFolder());
            try (BatchProcessor processor = ProcessorFactory.fileBatchProcessor((ProcessorConfig)resultConfig);){
                VeraAppConfig applicationConfig = this.configManager.getApplicationConfig();
                this.batchSummary = processor.process(this.pdfs, ProcessorFactory.getHandler((FormatOption)FormatOption.MRR, (boolean)applicationConfig.isVerbose(), (OutputStream)mrrReport, (int)applicationConfig.getMaxFailsDisplayed(), (boolean)validatorConfig.isRecordPasses()));
                if (isPolicy) {
                    this.applyPolicy();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ERROR_IN_OPEN_STREAMS, e);
            this.parent.handleValidationError("Can't open stream from PDF file or can't open stream to temporary XML report file: ", e);
        }
        catch (VeraPDFException e) {
            logger.log(Level.SEVERE, ERROR_IN_PROCESSING, e);
            this.parent.handleValidationError("Error during the processing: ", e);
        }
        if (this.batchSummary != null) {
            this.writeHtmlReport();
        }
        return this.batchSummary;
    }

    private void applyPolicy() throws IOException, VeraPDFException {
        File tempMrrFile = this.xmlReport;
        this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
        this.xmlReport.deleteOnExit();
        File tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        tempPolicyResult.deleteOnExit();
        try (FileInputStream mrrIs = new FileInputStream(tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);
             FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            PolicyChecker.applyPolicy((File)this.policy, (InputStream)mrrIs, (OutputStream)policyResultOs);
            PolicyChecker.insertPolicyReport((File)tempPolicyResult, (File)tempMrrFile, (OutputStream)mrrReport);
        }
    }

    @Override
    protected void done() {
        this.parent.validationEnded(this.xmlReport, this.htmlReport);
    }

    private void writeHtmlReport() {
        String extension = "html";
        String ext = ".html";
        try {
            this.htmlReport = File.createTempFile("veraPDF-tempHTMLReport", ".html");
            this.htmlReport.deleteOnExit();
            try (FileInputStream xmlStream = new FileInputStream(this.xmlReport);
                 FileOutputStream htmlStream = new FileOutputStream(this.htmlReport);){
                HTMLReport.writeHTMLReport((InputStream)xmlStream, (OutputStream)htmlStream, (BatchSummary)this.batchSummary, (String)this.configManager.getApplicationConfig().getWikiPath(), (boolean)true);
            }
            catch (IOException | TransformerException excep) {
                String message = String.format("IOException when saving the %S report.", "html");
                JOptionPane.showMessageDialog(this.parent, String.format("IOException when saving the %S report.", "html"), "Error", 0);
                logger.log(Level.SEVERE, message, excep);
                this.htmlReport = null;
            }
        }
        catch (IOException excep) {
            String message = String.format("IOException when saving the %S report.", "html");
            JOptionPane.showMessageDialog(this.parent, message, "Error", 0);
            logger.log(Level.SEVERE, message, excep);
            this.htmlReport = null;
        }
    }
}

