/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosDict
extends PBCosObject
implements CosDict {
    public static final String COS_DICT_TYPE = "CosDict";
    public static final String KEYS = "keys";
    public static final String VALUES = "values";
    public static final String METADATA = "metadata";
    private final int size;
    protected final PDDocument document;
    protected final PDFAFlavour flavour;

    public PBCosDict(COSDictionary dictionary, PDDocument document, PDFAFlavour flavour) {
        this(dictionary, COS_DICT_TYPE, document, flavour);
    }

    protected PBCosDict(COSDictionary dictionary, String type, PDDocument document, PDFAFlavour flavour) {
        super(dictionary, type);
        this.size = dictionary.size();
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Long getsize() {
        return this.size;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "keys": {
                return this.getKeys();
            }
            case "values": {
                return this.getValues();
            }
            case "metadata": {
                return this.getMetadata();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosName> getKeys() {
        COSDictionary dictionary = (COSDictionary)this.baseObject;
        ArrayList<CosName> list = new ArrayList<CosName>(dictionary.size());
        for (COSName key : dictionary.keySet()) {
            if (key == null) continue;
            list.add((CosName)PBCosDict.getFromValue(key, this.document, this.flavour));
        }
        return Collections.unmodifiableList(list);
    }

    private List<CosObject> getValues() {
        COSDictionary dictionary = (COSDictionary)this.baseObject;
        ArrayList<CosObject> list = new ArrayList<CosObject>(dictionary.size());
        for (COSBase value : dictionary.getValues()) {
            if (value == null) continue;
            list.add(PBCosDict.getFromValue(value, this.document, this.flavour));
        }
        return Collections.unmodifiableList(list);
    }

    private List<PDMetadata> getMetadata() {
        COSDictionary dictionary = (COSDictionary)this.baseObject;
        COSBase meta = dictionary.getDictionaryObject(COSName.METADATA);
        COSName type = dictionary.getCOSName(COSName.TYPE);
        if (PBoxPDMetadata.isMetadataObject(meta) && type != COSName.CATALOG) {
            ArrayList<PDMetadata> pdMetadatas = new ArrayList<PDMetadata>(1);
            org.apache.pdfbox.pdmodel.common.PDMetadata md = new org.apache.pdfbox.pdmodel.common.PDMetadata((COSStream)meta);
            pdMetadatas.add(new PBoxPDMetadata(md, Boolean.FALSE, this.document, this.flavour));
            return pdMetadatas;
        }
        return Collections.emptyList();
    }
}

