/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.operator.textshow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.factory.font.FontFactory;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.impl.pb.operator.base.PBOperator;
import org.verapdf.model.impl.pb.operator.textshow.PBCIDGlyph;
import org.verapdf.model.impl.pb.operator.textshow.PBGlyph;
import org.verapdf.model.operator.OpTextShow;
import org.verapdf.model.pdlayer.PDFont;
import org.verapdf.model.tools.FontHelper;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public abstract class PBOpTextShow
extends PBOperator
implements OpTextShow {
    private static final Logger LOGGER = Logger.getLogger(PBOpTextShow.class);
    private static final String MSG_PROBLEM_OBTAINING_RESOURCE = "Problem encountered while obtaining resources for ";
    public static final String FONT = "font";
    public static final String USED_GLYPHS = "usedGlyphs";
    public static final String FILL_COLOR_SPACE = "fillCS";
    public static final String STROKE_COLOR_SPACE = "strokeCS";
    protected final GraphicState state;
    private final PDInheritableResources resources;
    protected final PDDocument document;
    protected final PDFAFlavour flavour;
    private List<PDFont> fonts = null;
    private List<org.verapdf.model.pdlayer.PDColorSpace> fillCS = null;
    private List<org.verapdf.model.pdlayer.PDColorSpace> strokeCS = null;

    protected PBOpTextShow(List<COSBase> arguments, GraphicState state, PDInheritableResources resources, String opType, PDDocument document, PDFAFlavour flavour) {
        super(arguments, opType);
        this.state = state;
        this.resources = resources;
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "font": {
                return this.getFont();
            }
            case "usedGlyphs": {
                return this.getUsedGlyphs();
            }
            case "fillCS": {
                return this.getFillColorSpace();
            }
            case "strokeCS": {
                return this.getStrokeColorSpace();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFont> getFont() {
        if (this.fonts == null) {
            this.fonts = this.parseFont();
        }
        return this.fonts;
    }

    public PDFont getVeraModelFont() {
        if (this.fonts == null) {
            this.fonts = this.parseFont();
        }
        return this.fonts.isEmpty() ? null : this.fonts.get(0);
    }

    private List<PDFont> parseFont() {
        PDFont font = FontFactory.parseFont(this.getFontFromResources(), this.state.getRenderingMode(), this.resources, this.document, this.flavour);
        if (font != null) {
            ArrayList<PDFont> result = new ArrayList<PDFont>(1);
            result.add(font);
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List<PBGlyph> getUsedGlyphs() {
        org.apache.pdfbox.pdmodel.font.PDFont font = this.getFontFromResources();
        FontContainer<? extends PDFontLike> fontContainer = FontHelper.getFontContainer(font);
        if (fontContainer == null) {
            return Collections.emptyList();
        }
        boolean fontProgramIsInvalid = font.isDamaged() || PBOpTextShow.fontProgramIsNull(font);
        ArrayList<PBGlyph> res = new ArrayList<PBGlyph>();
        List<byte[]> strings = PBOpTextShow.getStrings(this.arguments);
        for (byte[] string : strings) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(string);){
                while (((InputStream)inputStream).available() > 0) {
                    PBGlyph glyph;
                    int code = font.readCode(inputStream);
                    Boolean glyphPresent = null;
                    Boolean widthsConsistent = null;
                    if (!fontProgramIsInvalid) {
                        glyphPresent = code == 0 ? true : Boolean.valueOf(fontContainer.hasGlyph(code));
                        widthsConsistent = this.checkWidths(code);
                    }
                    if (font.getSubType().equals("Type0")) {
                        int CID = ((PDType0Font)font).codeToCID(code);
                        glyph = new PBCIDGlyph(glyphPresent, widthsConsistent, font, code, CID, this.state.getRenderingMode().intValue());
                    } else {
                        glyph = new PBGlyph(glyphPresent, widthsConsistent, font, code, this.state.getRenderingMode().intValue());
                    }
                    res.add(glyph);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Error processing text show operator's string argument : " + new String(string));
                LOGGER.info(e);
            }
        }
        return res;
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getFillColorSpace() {
        if (this.fillCS == null) {
            this.fillCS = this.parseFillColorSpace();
        }
        return this.fillCS;
    }

    public byte[] getCharCodes() {
        List<byte[]> strings = PBOpTextShow.getStrings(this.arguments);
        HashSet<Byte> resSet = new HashSet<Byte>();
        for (byte[] string : strings) {
            for (byte b : string) {
                resSet.add(b);
            }
        }
        byte[] res = new byte[resSet.size()];
        int i = 0;
        Object object = resSet.iterator();
        while (object.hasNext()) {
            Byte b = (Byte)object.next();
            res[i++] = b;
        }
        return res;
    }

    public org.verapdf.model.pdlayer.PDColorSpace getVeraModelFillColorSpace() {
        if (this.fillCS == null) {
            this.fillCS = this.parseFillColorSpace();
        }
        return this.fillCS.isEmpty() ? null : this.fillCS.get(0);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getStrokeColorSpace() {
        if (this.strokeCS == null) {
            this.strokeCS = this.parseStrokeColorSpace();
        }
        return this.strokeCS;
    }

    public org.verapdf.model.pdlayer.PDColorSpace getVeraModelStrokeColorSpace() {
        if (this.strokeCS == null) {
            this.strokeCS = this.parseStrokeColorSpace();
        }
        return this.strokeCS.isEmpty() ? null : this.strokeCS.get(0);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> parseFillColorSpace() {
        if (this.state.getRenderingMode().isFill()) {
            return this.getColorSpace(this.state.getFillColorSpace(), this.state.getFillPattern(), this.state.isOverprintingFlagNonStroke());
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> parseStrokeColorSpace() {
        if (this.state.getRenderingMode().isStroke()) {
            return this.getColorSpace(this.state.getStrokeColorSpace(), this.state.getStrokePattern(), this.state.isOverprintingFlagStroke());
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace(PDColorSpace usedColorSpace, PDAbstractPattern pattern, boolean op) {
        org.verapdf.model.pdlayer.PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace(usedColorSpace, pattern, this.resources, this.state.getOpm(), op, this.document, this.flavour);
        if (colorSpace != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpaces.add(colorSpace);
            return Collections.unmodifiableList(colorSpaces);
        }
        return Collections.emptyList();
    }

    private boolean checkWidths(int glyphCode) throws IOException {
        org.apache.pdfbox.pdmodel.font.PDFont font = this.getFontFromResources();
        float expectedWidth = font.getWidth(glyphCode);
        float foundWidth = font.getWidthFromFont(glyphCode);
        return Math.abs(foundWidth - expectedWidth) <= 1.0f;
    }

    private static List<byte[]> getStrings(List<COSBase> argList) {
        if (!argList.isEmpty()) {
            ArrayList<byte[]> res = new ArrayList<byte[]>();
            COSBase arg = argList.get(0);
            if (arg instanceof COSArray) {
                PBOpTextShow.addArrayElements(res, (COSArray)arg);
            } else if (arg instanceof COSString) {
                res.add(((COSString)arg).getBytes());
            }
            return res;
        }
        return Collections.emptyList();
    }

    private static void addArrayElements(List<byte[]> res, COSArray arg) {
        for (COSBase element : arg) {
            if (!(element instanceof COSString)) continue;
            res.add(((COSString)element).getBytes());
        }
    }

    private org.apache.pdfbox.pdmodel.font.PDFont getFontFromResources() {
        if (this.resources == null) {
            return null;
        }
        try {
            return this.resources.getFont(this.state.getFontName());
        }
        catch (IOException e) {
            LOGGER.debug(MSG_PROBLEM_OBTAINING_RESOURCE + this.state.getFontName().getName() + ". " + e.getMessage(), e);
            return null;
        }
    }

    private static boolean fontProgramIsNull(org.apache.pdfbox.pdmodel.font.PDFont font) {
        if (font instanceof PDType3Font) {
            return false;
        }
        if (font instanceof PDType0Font) {
            return PBOpTextShow.descendantFontProgramIsNull((PDType0Font)font);
        }
        if (!font.getSubType().equals("Type3") && font.isEmbedded()) {
            PDStream fontFile = font.getSubType().equals("Type1") || font.getSubType().equals("MMType1") ? (font instanceof PDType1CFont ? font.getFontDescriptor().getFontFile3() : font.getFontDescriptor().getFontFile()) : (font.getSubType().equals("CIDFontType2") || font.getSubType().equals("TrueType") ? font.getFontDescriptor().getFontFile2() : font.getFontDescriptor().getFontFile3());
            if (fontFile != null) {
                return false;
            }
        }
        return true;
    }

    private static boolean descendantFontProgramIsNull(PDType0Font font) {
        PDCIDFont descendant = font.getDescendantFont();
        if (descendant instanceof PDCIDFontType2) {
            if (descendant.getFontDescriptor() != null) {
                return descendant.getFontDescriptor().getFontFile3() == null && descendant.getFontDescriptor().getFontFile2() == null;
            }
        } else {
            return descendant.getFontDescriptor().getFontFile3() == null;
        }
        return true;
    }
}

