/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.PBoxPDFormField;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.signatures.PBoxPDSignatureField;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDFormField;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDAcroForm
extends PBoxPDObject
implements PDAcroForm {
    public static final String ACRO_FORM_TYPE = "PDAcroForm";
    public static final String FORM_FIELDS = "formFields";
    private final boolean needAppearance;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDAcroForm(org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm acroForm, PDDocument document, PDFAFlavour flavour) {
        super(acroForm, ACRO_FORM_TYPE);
        this.needAppearance = acroForm.getNeedAppearances();
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Boolean getNeedAppearances() {
        return this.needAppearance;
    }

    @Override
    public Boolean getcontainsXFA() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.XFA);
    }

    @Override
    public String getdynamicRender() {
        return null;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "formFields": {
                return this.getFormFields();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFormField> getFormFields() {
        List<PDField> fields = ((org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm)this.simplePDObject).getFields();
        ArrayList<PBoxPDFormField> formFields = new ArrayList<PBoxPDFormField>(1);
        for (PDField field : fields) {
            if (field instanceof PDSignatureField) {
                formFields.add(new PBoxPDSignatureField((PDSignatureField)field, this.document));
                continue;
            }
            formFields.add(new PBoxPDFormField(field));
        }
        return Collections.unmodifiableList(formFields);
    }
}

