/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.pattern;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.pd.PBoxPDResource;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDShading
extends PBoxPDResource
implements org.verapdf.model.pdlayer.PDShading {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDShading.class);
    public static final String SHADING_TYPE = "PDShading";
    public static final String COLOR_SPACE = "colorSpace";
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDShading(PDShading simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, SHADING_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (COLOR_SPACE.equals(link)) {
            return this.getColorSpace();
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace() {
        try {
            PDColorSpace cs = ((PDShading)this.simplePDObject).getColorSpace();
            if (cs != null) {
                ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
                colorSpaces.add(ColorSpaceFactory.getColorSpace(cs, this.document, this.flavour));
                return Collections.unmodifiableList(colorSpaces);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Problems with color space obtaining from shading. " + e.getMessage(), e);
        }
        return Collections.emptyList();
    }
}

