/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.PDFontSetting;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.verapdf.model.impl.pb.containers.StaticContainers;

public class FileSpecificationKeysHelper {
    private static final Logger LOGGER = Logger.getLogger(FileSpecificationKeysHelper.class);
    private static Set<COSObjectKey> visitedKeys = new HashSet<COSObjectKey>();

    public static void registerFileSpecificationKeys(PDDocument document) {
        PDPageTree pageTree;
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        if (catalog != null) {
            FileSpecificationKeysHelper.registerDictionaryAFKeys(catalog.getCOSObject());
            FileSpecificationKeysHelper.processStructElements(catalog.getStructureTreeRoot());
        }
        if ((pageTree = document.getPages()) != null) {
            FileSpecificationKeysHelper.registerDictionaryAFKeys(pageTree.getCOSObject());
            for (PDPage page : pageTree) {
                FileSpecificationKeysHelper.processPage(page);
            }
        }
        visitedKeys.clear();
    }

    private static void processStructElements(PDStructureNode structureNode) {
        if (structureNode != null) {
            for (Object obj : structureNode.getKids()) {
                if (!(obj instanceof PDStructureElement)) continue;
                PDStructureElement element = (PDStructureElement)obj;
                FileSpecificationKeysHelper.registerDictionaryAFKeys(element.getCOSObject());
                FileSpecificationKeysHelper.processStructElements(element);
            }
        }
    }

    private static void processPage(PDPage page) {
        if (page != null) {
            FileSpecificationKeysHelper.registerDictionaryAFKeys(page.getCOSObject());
            try {
                for (PDAnnotation annotation : page.getAnnotations()) {
                    if (annotation == null) continue;
                    FileSpecificationKeysHelper.registerDictionaryAFKeys(annotation.getCOSObject());
                    for (PDAppearanceStream stream : FileSpecificationKeysHelper.getAllAppearances(annotation)) {
                        FileSpecificationKeysHelper.processXObject(stream);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Can not get page annotations", e);
            }
            FileSpecificationKeysHelper.parseResources(page.getResources());
        }
    }

    private static void processXObject(PDXObject xObject) {
        if (xObject == null || FileSpecificationKeysHelper.isKeyVisited(xObject.getCOSObject().getKey())) {
            return;
        }
        FileSpecificationKeysHelper.registerDictionaryAFKeys((COSDictionary)xObject.getCOSObject());
        if (xObject instanceof PDFormXObject) {
            FileSpecificationKeysHelper.parseResources(((PDFormXObject)xObject).getResources());
        } else if (xObject instanceof PDImageXObjectProxy) {
            try {
                FileSpecificationKeysHelper.processXObject(((PDImageXObjectProxy)xObject).getMask());
            }
            catch (IOException e) {
                LOGGER.error("Can not obtain Image xobject Mask", e);
            }
            try {
                FileSpecificationKeysHelper.processXObject(((PDImageXObjectProxy)xObject).getMask());
            }
            catch (IOException e) {
                LOGGER.error("Can not obtain Image xobject SMask", e);
            }
            FileSpecificationKeysHelper.processImageAlternates((PDImageXObjectProxy)xObject);
        }
    }

    private static void processImageAlternates(PDImageXObjectProxy xObject) {
        COSBase alternates = ((COSDictionary)xObject.getCOSObject()).getDictionaryObject(COSName.getPDFName("Alternates"));
        if (alternates instanceof COSArray) {
            for (COSBase obj : (COSArray)alternates) {
                COSBase image;
                if (!(obj instanceof COSDictionary) || !((image = ((COSDictionary)obj).getDictionaryObject(COSName.IMAGE)) instanceof COSStream)) continue;
                FileSpecificationKeysHelper.processXObject(new PDImageXObjectProxy(new PDStream((COSStream)image), null));
            }
        }
    }

    private static List<PDAppearanceStream> getAllAppearances(PDAnnotation annotation) {
        PDAppearanceDictionary appearance;
        ArrayList<PDAppearanceStream> res = new ArrayList<PDAppearanceStream>();
        if (annotation != null && (appearance = annotation.getAppearance()) != null) {
            FileSpecificationKeysHelper.addAllAppearances(appearance.getNormalAppearance(), res);
            FileSpecificationKeysHelper.addAllAppearances(appearance.getDownAppearance(), res);
            FileSpecificationKeysHelper.addAllAppearances(appearance.getRolloverAppearance(), res);
        }
        return res;
    }

    private static void addAllAppearances(PDAppearanceEntry appearance, List<PDAppearanceStream> list) {
        if (appearance == null) {
            return;
        }
        if (appearance.isStream()) {
            PDAppearanceStream appearanceStream = appearance.getAppearanceStream();
            if (appearanceStream != null) {
                list.add(appearanceStream);
            }
        } else {
            for (PDAppearanceStream appearanceStream : appearance.getSubDictionary().values()) {
                if (appearanceStream == null) continue;
                list.add(appearanceStream);
            }
        }
    }

    private static void registerDictionaryAFKeys(COSDictionary dictionary) {
        if (dictionary == null) {
            return;
        }
        COSBase af = dictionary.getDictionaryObject(COSName.getPDFName("AF"));
        if (af instanceof COSArray) {
            for (COSBase element : (COSArray)af) {
                FileSpecificationKeysHelper.addElementKey(element);
            }
        }
    }

    private static void processExtGState(PDExtendedGraphicsState extGState) {
        if (extGState == null || FileSpecificationKeysHelper.isKeyVisited(extGState.getCOSObject().getKey())) {
            return;
        }
        PDFontSetting fontSetting = extGState.getFontSetting();
        if (fontSetting != null) {
            try {
                FileSpecificationKeysHelper.processFont(fontSetting.getFont());
            }
            catch (IOException e) {
                LOGGER.error("Can not obtain font from extGState's font settings", e);
            }
        }
    }

    private static void processFont(PDFont font) {
        if (font instanceof PDType3Font && !FileSpecificationKeysHelper.isKeyVisited(font.getCOSObject().getKey())) {
            FileSpecificationKeysHelper.parseResources(((PDType3Font)font).getResources());
        }
    }

    private static void processPattern(PDAbstractPattern pattern) {
        if (pattern == null || FileSpecificationKeysHelper.isKeyVisited(pattern.getCOSObject().getKey())) {
            return;
        }
        if (pattern instanceof PDTilingPattern) {
            FileSpecificationKeysHelper.parseResources(((PDTilingPattern)pattern).getResources());
        } else if (pattern instanceof PDShadingPattern) {
            FileSpecificationKeysHelper.processExtGState(((PDShadingPattern)pattern).getExtendedGraphicsState());
        }
    }

    private static void parseResources(PDResources resources) {
        if (resources != null && !FileSpecificationKeysHelper.isKeyVisited(resources.getCOSObject().getKey())) {
            FileSpecificationKeysHelper.parseResourcesXObjects(resources);
            FileSpecificationKeysHelper.parseResourcesExtGState(resources);
            FileSpecificationKeysHelper.parseResourcesPatterns(resources);
            FileSpecificationKeysHelper.parseResourcesFonts(resources);
        }
    }

    private static void parseResourcesPatterns(PDResources resources) {
        for (COSName name : resources.getPatternNames()) {
            try {
                PDAbstractPattern pattern = resources.getPattern(name);
                FileSpecificationKeysHelper.processPattern(pattern);
            }
            catch (IOException e) {
                LOGGER.error("Can not obtain pattern from resources", e);
            }
        }
    }

    private static void parseResourcesExtGState(PDResources resources) {
        for (COSName name : resources.getExtGStateNames()) {
            PDExtendedGraphicsState extGState = resources.getExtGState(name);
            FileSpecificationKeysHelper.processExtGState(extGState);
        }
    }

    private static void parseResourcesXObjects(PDResources resources) {
        for (COSName name : resources.getXObjectNames()) {
            try {
                PDXObject xObject = resources.getXObject(name);
                FileSpecificationKeysHelper.processXObject(xObject);
            }
            catch (IOException e) {
                LOGGER.error("Can not obtain xobject from resources", e);
            }
        }
    }

    private static void parseResourcesFonts(PDResources resources) {
        for (COSName name : resources.getFontNames()) {
            try {
                PDFont font = resources.getFont(name);
                FileSpecificationKeysHelper.processFont(font);
            }
            catch (IOException e) {
                LOGGER.error("Can not obtain font from resources", e);
            }
        }
    }

    private static void addElementKey(COSBase element) {
        COSObjectKey key;
        COSBase base = element;
        while (base instanceof COSObject) {
            base = ((COSObject)base).getObject();
        }
        if (base != null && (key = base.getKey()) != null) {
            StaticContainers.getFileSpecificationKeys().add(key);
        }
    }

    private static boolean isKeyVisited(COSObjectKey key) {
        if (visitedKeys.contains(key)) {
            return true;
        }
        visitedKeys.add(key);
        return false;
    }
}

