/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.gui.ChooseFlavourRenderer;
import org.verapdf.gui.LogoPanel;
import org.verapdf.gui.ValidateWorker;
import org.verapdf.gui.utils.DialogUtils;
import org.verapdf.gui.utils.GUIConstants;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.TaskType;

class CheckerPanel
extends JPanel {
    private static transient ConfigManager config;
    private static final long serialVersionUID = 1290058869994329766L;
    private static final Logger logger;
    private static final Map<String, PDFAFlavour> FLAVOURS_MAP;
    private static final String emptyString = "";
    private JFileChooser pdfChooser;
    private JFileChooser xmlChooser;
    private JFileChooser htmlChooser;
    private JFileChooser policyChooser;
    private List<File> pdfsToProcess;
    private JTextField chosenPDF;
    private JTextField chosenProfile;
    private JTextField chosenPolicy;
    private JLabel resultLabel;
    private File xmlReport;
    private File htmlReport;
    private File policy;
    private JComboBox<ProcessType> ProcessTypes;
    private JCheckBox fixMetadata;
    private JComboBox<String> chooseFlavour;
    private boolean isValidationErrorOccurred;
    private JButton execute;
    private JButton saveXML;
    private JButton viewXML;
    private JButton saveHTML;
    private JButton viewHTML;
    private DropTarget targetPDF;
    private DropTarget targetPolicy;
    private DropTarget targetProfile;
    private transient Path profilePath;
    private JProgressBar progressBar;
    transient ValidateWorker validateWorker;

    CheckerPanel(ConfigManager config) throws IOException {
        CheckerPanel.config = config;
        this.profilePath = FileSystems.getDefault().getPath(emptyString, new String[0]);
        this.initGui();
        this.pdfChooser = CheckerPanel.getChooser(true, "pdf");
        this.pdfChooser.setMultiSelectionEnabled(true);
        this.pdfChooser.setFileSelectionMode(2);
        this.xmlChooser = CheckerPanel.getChooser(false, "xml");
        this.htmlChooser = CheckerPanel.getChooser(false, "html");
        this.policyChooser = CheckerPanel.getChooser(false, "sch", "xsl", "xslt");
        this.addActionListeners();
    }

    private void addActionListeners() {
        this.execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CheckerPanel.this.changeConfig();
                    ValidationProfile customProfile = null;
                    if ("Custom profile".equals(CheckerPanel.this.chooseFlavour.getSelectedItem())) {
                        try (FileInputStream is = new FileInputStream(CheckerPanel.this.profilePath.toFile());){
                            customProfile = Profiles.profileFromXml(is);
                        }
                    }
                    CheckerPanel.this.validateWorker = new ValidateWorker(CheckerPanel.this, CheckerPanel.this.pdfsToProcess, config, customProfile, CheckerPanel.this.policy);
                    CheckerPanel.this.progressBar.setVisible(true);
                    CheckerPanel.this.resultLabel.setVisible(false);
                    CheckerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    CheckerPanel.this.execute.setEnabled(false);
                    CheckerPanel.this.isValidationErrorOccurred = false;
                    CheckerPanel.this.viewXML.setEnabled(false);
                    CheckerPanel.this.saveXML.setEnabled(false);
                    CheckerPanel.this.viewHTML.setEnabled(false);
                    CheckerPanel.this.saveHTML.setEnabled(false);
                    CheckerPanel.this.validateWorker.execute();
                }
                catch (IOException | IllegalArgumentException | JAXBException excep) {
                    DialogUtils.errorDialog(CheckerPanel.this, excep.getMessage(), logger, excep);
                }
            }
        });
        this.saveXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.xmlChooser, "xml", CheckerPanel.this.xmlReport);
            }
        });
        this.saveHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.htmlChooser, "html", CheckerPanel.this.htmlReport);
            }
        });
        this.viewXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.xmlReport == null) {
                    String message = String.format("Unresolvable problem occured when saving the %S report.", "xml");
                    DialogUtils.errorDialog(CheckerPanel.this, message, logger, new IOException(message));
                } else {
                    this.openXMLReport();
                }
            }

            private void openXMLReport() {
                try {
                    Desktop.getDesktop().open(CheckerPanel.this.xmlReport);
                }
                catch (IOException excep) {
                    String message = String.format("Could not open %s using the default Desktop application for %S file type. Please, try opening this file manually.", CheckerPanel.this.xmlReport.getAbsolutePath(), "xml");
                    DialogUtils.errorDialog(CheckerPanel.this, message, logger, excep);
                }
            }
        });
        this.viewHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.htmlReport == null) {
                    String message = String.format("Unresolvable problem occured when saving the %S report.", "html");
                    DialogUtils.errorDialog(CheckerPanel.this, message, logger, new IOException(message));
                } else {
                    try {
                        Desktop.getDesktop().open(CheckerPanel.this.htmlReport);
                    }
                    catch (IOException excep) {
                        String message = String.format("Could not open %s using the default Desktop application for %S file type. Please, try opening this file manually.", CheckerPanel.this.htmlReport.getAbsolutePath(), "html");
                        DialogUtils.errorDialog(CheckerPanel.this, message, logger, excep);
                    }
                }
            }
        });
    }

    private void initGui() throws IOException {
        this.setPreferredSize(new Dimension(450, 200));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.chosenPDF = new JTextField("PDF file not chosen");
        this.chosenPDF.setEditable(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 0, 4, 1, 4, 1, 2);
        gbl.setConstraints(this.chosenPDF, gbc);
        gbc.fill = 2;
        this.add(this.chosenPDF);
        PanelDropTargetListener dtdPDFListener = new PanelDropTargetListener(-1, "pdf");
        this.targetPDF = new DropTarget(this.chosenPDF, 3, dtdPDFListener, true, null);
        JButton choosePDF = new JButton("Choose PDF");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 4, 0, 0, 1, 1, 1, 2);
        gbl.setConstraints(choosePDF, gbc);
        this.add(choosePDF);
        choosePDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.pdfChooser, new String[]{"pdf"});
            }
        });
        JLabel processType = new JLabel(" Report type:   ");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(processType, gbc);
        processType.setHorizontalAlignment(4);
        this.add(processType);
        this.ProcessTypes = new JComboBox<ProcessType>(ProcessType.getOptionValues());
        this.ProcessTypes.setSelectedItem((Object)config.getApplicationConfig().getProcessType());
        ProcessingTypeRenderer processingTypeRenderer = new ProcessingTypeRenderer();
        this.ProcessTypes.setRenderer(processingTypeRenderer);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 1, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.ProcessTypes, gbc);
        this.add(this.ProcessTypes);
        this.fixMetadata = new JCheckBox("       Fix metadata:");
        this.fixMetadata.setHorizontalTextPosition(2);
        this.fixMetadata.setSelected(config.createProcessorConfig().getTasks().contains((Object)TaskType.FIX_METADATA));
        CheckerPanel.setGridBagConstraintsParameters(gbc, 2, 3, 1, 1, 1, 1, 2);
        gbl.setConstraints(this.fixMetadata, gbc);
        this.add(this.fixMetadata);
        this.fixMetadata.setHorizontalAlignment(0);
        if (config.getApplicationConfig().getProcessType() == ProcessType.EXTRACT) {
            this.fixMetadata.setEnabled(false);
        }
        JLabel chooseFlavourLabel = new JLabel("PDF flavour:   ");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 3, 0, 1, 1, 1, 2);
        chooseFlavourLabel.setHorizontalAlignment(4);
        gbl.setConstraints(chooseFlavourLabel, gbc);
        this.add(chooseFlavourLabel);
        Vector<String> availableFlavours = new Vector<String>();
        availableFlavours.add("Custom profile");
        availableFlavours.add("Auto-detect");
        TreeSet<String> sortedFlavours = new TreeSet<String>();
        for (PDFAFlavour flavour : Profiles.getVeraProfileDirectory().getPDFAFlavours()) {
            String flavourReadableText = CheckerPanel.getFlavourReadableText(flavour);
            sortedFlavours.add(flavourReadableText);
            FLAVOURS_MAP.put(flavourReadableText, flavour);
        }
        availableFlavours.addAll(sortedFlavours);
        this.chooseFlavour = new JComboBox(availableFlavours);
        this.chooseFlavour.setOpaque(true);
        ChooseFlavourRenderer renderer = new ChooseFlavourRenderer();
        this.chooseFlavour.setRenderer(renderer);
        PDFAFlavour fromConfig = config.createProcessorConfig().getValidatorConfig().getFlavour();
        String fromConfigFlavourText = CheckerPanel.getFlavourReadableText(fromConfig);
        if (availableFlavours.contains(fromConfigFlavourText)) {
            this.chooseFlavour.setSelectedItem(fromConfigFlavourText);
        } else {
            this.chooseFlavour.setSelectedItem("Auto-detect");
        }
        CheckerPanel.setGridBagConstraintsParameters(gbc, 4, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.chooseFlavour, gbc);
        this.add(this.chooseFlavour);
        this.chosenProfile = new JTextField("Validation profile not chosen");
        this.chosenProfile.setEditable(false);
        this.chosenProfile.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 1, 4, 1, 4, 1, 2);
        gbl.setConstraints(this.chosenProfile, gbc);
        this.add(this.chosenProfile);
        PanelDropTargetListener dtdProfileListener = new PanelDropTargetListener(1, "xml");
        this.targetProfile = new DropTarget(this.chosenProfile, 3, dtdProfileListener, true, null);
        this.targetProfile.setActive(false);
        if (!this.profilePath.toString().isEmpty()) {
            this.chosenProfile.setText(this.profilePath.toString());
        } else {
            this.chosenProfile.setText("Please, specify validation profile");
        }
        this.setupProfileButton(gbl, gbc);
        String policyPath = config.getApplicationConfig().getPolicyFile();
        if (policyPath == null || policyPath.isEmpty()) {
            policyPath = "Policy file not chosen";
        }
        this.chosenPolicy = new JTextField(policyPath);
        this.chosenPolicy.setEditable(false);
        this.chosenPolicy.setEnabled(this.ProcessTypes.getSelectedItem() == ProcessType.POLICY);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 2, 4, 1, 4, 1, 2);
        gbl.setConstraints(this.chosenPolicy, gbc);
        this.add(this.chosenPolicy);
        PanelDropTargetListener dtdPolicyListener = new PanelDropTargetListener(1, "sch", "xsl", "xslt");
        this.targetPolicy = new DropTarget(this.chosenPolicy, 3, dtdPolicyListener, true, null);
        this.targetPolicy.setActive(this.ProcessTypes.getSelectedItem() == ProcessType.POLICY);
        this.setupPolicyButton(gbl, gbc);
        this.resultLabel = new JLabel();
        this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
        this.resultLabel.setHorizontalTextPosition(0);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 4, 4, 1, 4, 1, 10);
        gbl.setConstraints(this.resultLabel, gbc);
        this.add(this.resultLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 4, 4, 1, 4, 1, 2);
        gbl.setConstraints(this.progressBar, gbc);
        this.add(this.progressBar);
        this.execute = new JButton("Execute");
        this.execute.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 4, 4, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.execute, gbc);
        this.add(this.execute);
        JPanel reports = CheckerPanel.createReportPanel(gbl, gbc);
        this.add(reports);
        this.setupReportPanel(reports);
    }

    private static JPanel createReportPanel(GridBagLayout gbl, GridBagConstraints gbc) {
        JPanel reports = new JPanel();
        reports.setBorder(BorderFactory.createTitledBorder("Report"));
        reports.setLayout(new GridLayout(2, 3));
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 5, 5, 3, 5, 1, 2);
        gbl.setConstraints(reports, gbc);
        return reports;
    }

    private void setupReportPanel(JPanel reports) throws IOException {
        LogoPanel xmlLogo = new LogoPanel("org/verapdf/gui/images/xml-logo.png", reports.getBackground(), 4);
        reports.add(xmlLogo);
        this.saveXML = new JButton("Save XML");
        this.saveXML.setEnabled(false);
        reports.add(this.saveXML);
        this.viewXML = new JButton("View XML");
        this.viewXML.setEnabled(false);
        reports.add(this.viewXML);
        LogoPanel htmlLogo = new LogoPanel("org/verapdf/gui/images/html-logo.png", reports.getBackground(), 4);
        reports.add(htmlLogo);
        this.saveHTML = new JButton("Save HTML");
        this.saveHTML.setEnabled(false);
        reports.add(this.saveHTML);
        this.viewHTML = new JButton("View HTML");
        this.viewHTML.setEnabled(false);
        reports.add(this.viewHTML);
    }

    private void setupProfileButton(GridBagLayout gbl, GridBagConstraints gbc) {
        final JButton chooseProfile = new JButton("Choose Profile");
        chooseProfile.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 4, 1, 0, 1, 1, 1, 2);
        gbl.setConstraints(chooseProfile, gbc);
        this.add(chooseProfile);
        this.chooseFlavour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CheckerPanel.this.chooseFlavour.getSelectedItem().equals("Custom profile")) {
                    chooseProfile.setEnabled(true);
                    CheckerPanel.this.chosenProfile.setEnabled(true);
                    CheckerPanel.this.targetProfile.setActive(true);
                } else {
                    chooseProfile.setEnabled(false);
                    CheckerPanel.this.chosenProfile.setEnabled(false);
                    CheckerPanel.this.targetProfile.setActive(false);
                }
                CheckerPanel.this.execute.setEnabled(CheckerPanel.this.isExecute());
            }
        });
        chooseProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.xmlChooser, new String[]{"xml"});
            }
        });
    }

    private void setupPolicyButton(GridBagLayout gbl, GridBagConstraints gbc) {
        final JButton choosePolicy = new JButton("Choose Policy");
        choosePolicy.setEnabled(this.ProcessTypes.getSelectedItem() == ProcessType.POLICY);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 4, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(choosePolicy, gbc);
        this.add(choosePolicy);
        choosePolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.policyChooser, new String[]{"sch", "xsl", "xslt"});
            }
        });
        this.ProcessTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessType item = (ProcessType)((Object)CheckerPanel.this.ProcessTypes.getSelectedItem());
                switch (item) {
                    case VALIDATE: {
                        this.updateEnabling(true, false);
                        break;
                    }
                    case EXTRACT: {
                        CheckerPanel.this.fixMetadata.setSelected(false);
                        this.updateEnabling(false, false);
                        break;
                    }
                    case VALIDATE_EXTRACT: {
                        this.updateEnabling(true, false);
                        break;
                    }
                    case POLICY: {
                        this.updateEnabling(true, true);
                        break;
                    }
                }
            }

            private void updateEnabling(boolean enableFixMetadata, boolean enablePolicy) {
                CheckerPanel.this.fixMetadata.setEnabled(enableFixMetadata);
                CheckerPanel.this.chosenPolicy.setEnabled(enablePolicy);
                choosePolicy.setEnabled(enablePolicy);
                CheckerPanel.this.targetPolicy.setActive(enablePolicy);
                CheckerPanel.this.execute.setEnabled(CheckerPanel.this.isExecute());
            }
        });
    }

    void validationEnded(File xmlReportFile, File htmlReportFile) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.execute.setEnabled(true);
        if (!this.isValidationErrorOccurred) {
            try {
                ValidateWorker.ValidateWorkerSummary result = (ValidateWorker.ValidateWorkerSummary)this.validateWorker.get();
                if (!result.getBatchSummary().isMultiJob()) {
                    if (result.getBatchSummary().getFailedParsingJobs() == 1) {
                        this.setResultMessage("Failed to parse pdf document.", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getBatchSummary().getFailedEncryptedJobs() == 1) {
                        this.setResultMessage("Document is password encrypted and can not be processed.", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.isPolicyApplied() && result.getPolicyNonCompliantJobCount() > 0) {
                        this.setResultMessage("PDF file is not compliant with Policy requirements", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getBatchSummary().getValidationSummary().getCompliantPdfaCount() > 0) {
                        this.setResultMessage("PDF file is compliant with Validation Profile requirements", GUIConstants.VALIDATION_SUCCESS_COLOR);
                    } else if (result.getBatchSummary().getValidationSummary().getNonCompliantPdfaCount() > 0) {
                        this.setResultMessage("PDF file is not compliant with Validation Profile requirements", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getBatchSummary().getValidationSummary().getFailedJobCount() == 1) {
                        this.setResultMessage("Could not complete validation due to an error.", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getBatchSummary().getFeaturesSummary().getTotalJobCount() > 0) {
                        this.setResultMessage("Features report generated.", GUIConstants.VALIDATION_SUCCESS_COLOR);
                    } else {
                        this.setResultMessage("Could not complete feature extraction due to an error.", GUIConstants.VALIDATION_FAILED_COLOR);
                    }
                } else {
                    this.setResultMessage(CheckerPanel.getBatchResultMessage(result), GUIConstants.BEFORE_VALIDATION_COLOR);
                }
                this.resultLabel.setVisible(true);
                this.xmlReport = xmlReportFile;
                this.htmlReport = htmlReportFile;
                if (xmlReportFile != null) {
                    this.saveXML.setEnabled(true);
                    this.viewXML.setEnabled(true);
                }
                if (!(htmlReportFile == null || result.getBatchSummary().isMultiJob() && this.ProcessTypes.getSelectedItem() == ProcessType.EXTRACT)) {
                    this.saveHTML.setEnabled(true);
                    this.viewHTML.setEnabled(true);
                }
            }
            catch (InterruptedException e) {
                this.handleValidationError("Process has been interrupted: ", e);
            }
            catch (ExecutionException e) {
                this.handleValidationError("Execution exception in processing: ", e);
            }
        }
    }

    private static String getBatchResultMessage(ValidateWorker.ValidateWorkerSummary result) {
        String divisor = ", ";
        StringBuilder sb = new StringBuilder(String.format("Items processed: %d", result.getBatchSummary().getTotalJobs()));
        String end = String.format("%s Parsing Error: %d", divisor, result.getBatchSummary().getFailedParsingJobs());
        if (result.getBatchSummary().getValidationSummary().getTotalJobCount() > 0) {
            end = String.format("%sValid: %d%sInvalid: %d%sError: %d", divisor, result.getBatchSummary().getValidationSummary().getCompliantPdfaCount(), divisor, result.getBatchSummary().getValidationSummary().getNonCompliantPdfaCount(), divisor, result.getBatchSummary().getValidationSummary().getFailedJobCount());
            sb.append(end);
        }
        if (result.getBatchSummary().getFeaturesSummary().getSuccessfulJobCount() > 0) {
            String old_end = end;
            end = String.format("%sFeatures generated: %d%s", divisor, result.getBatchSummary().getFeaturesSummary().getSuccessfulJobCount(), old_end);
            sb.append(end);
        }
        if (result.getPolicyNonCompliantJobCount() > 0) {
            end = String.format("%sPolicy invalid: %d", divisor, result.getPolicyNonCompliantJobCount());
            sb.append(end);
        }
        return sb.toString();
    }

    private void setResultMessage(String message, Color color) {
        this.resultLabel.setForeground(color);
        this.resultLabel.setText(message);
    }

    void handleValidationError(String message, Throwable cause) {
        cause.printStackTrace();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.isValidationErrorOccurred = true;
        DialogUtils.errorDialog(this, message + cause.getMessage(), logger, cause);
        this.resultLabel.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
        this.resultLabel.setText(message + cause.getMessage());
        this.resultLabel.setVisible(true);
    }

    private static JFileChooser getChooser(boolean allFilesAccept, String ... types) throws IOException {
        JFileChooser res = new JFileChooser();
        File currentDir = new File(new File(".").getCanonicalPath());
        res.setCurrentDirectory(currentDir);
        res.setAcceptAllFileFilterUsed(allFilesAccept);
        res.setFileFilter(new FileNameExtensionFilter(CheckerPanel.elementsCommaDelimeted(types), types));
        return res;
    }

    private static String elementsCommaDelimeted(String ... elements) {
        StringBuilder description = new StringBuilder(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            description.append(",").append(elements[i]);
        }
        return description.toString();
    }

    private static void setGridBagConstraintsParameters(GridBagConstraints gbc, int gridx, int gridy, int weightx, int weighty, int gridwidth, int gridheight, int fill) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
    }

    private void chooseFile(JFileChooser chooser, String[] extensions) {
        int resultChoose = chooser.showOpenDialog(this);
        if (resultChoose == 0) {
            File[] chosenFiles = chooser.getSelectedFiles();
            if (chosenFiles == null || chosenFiles.length == 0) {
                chosenFiles = new File[]{chooser.getSelectedFile()};
            }
            List<File> selectedFiles = Arrays.asList(chosenFiles);
            this.insertFilesInfo(selectedFiles, extensions);
        }
    }

    public void insertFilesInfo(List<File> selectedFiles, String[] extensions) {
        if (!ApplicationUtils.doAllFilesExist(selectedFiles)) {
            DialogUtils.errorDialog(this, "Error! One of the selected files can't be found.", logger, new FileNotFoundException("Error! One of the selected files can't be found."));
        } else {
            this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
            this.resultLabel.setText(emptyString);
            this.xmlReport = null;
            this.htmlReport = null;
            this.saveXML.setEnabled(false);
            this.viewXML.setEnabled(false);
            this.saveHTML.setEnabled(false);
            this.viewHTML.setEnabled(false);
            switch (extensions[0]) {
                case "pdf": {
                    this.pdfsToProcess = ApplicationUtils.filterPdfFiles(selectedFiles, true, true);
                    this.chosenPDF.setText(CheckerPanel.getSelectedPathsMessage(selectedFiles));
                    break;
                }
                case "xml": {
                    if (selectedFiles.size() == 1) {
                        this.profilePath = selectedFiles.get(0).toPath().toAbsolutePath();
                        this.chosenProfile.setText(this.profilePath.toString());
                        break;
                    }
                    String message = String.format("Error! You can only choose a single %s.", "validation profile");
                    DialogUtils.errorDialog(this, message, logger, new IllegalArgumentException(message));
                    break;
                }
                case "sch": 
                case "xsl": 
                case "xslt": {
                    if (selectedFiles.size() == 1 && !selectedFiles.get(0).isDirectory()) {
                        this.policy = selectedFiles.get(0);
                        this.chosenPolicy.setText(this.policy.getAbsolutePath());
                        break;
                    }
                    String message = String.format("Error! You can only choose a single %s.", "policy file");
                    DialogUtils.errorDialog(this, message, logger, new IllegalArgumentException(message));
                    break;
                }
            }
            this.execute.setEnabled(this.isExecute());
        }
    }

    private static String getSelectedPathsMessage(List<File> files) {
        if (files != null && files.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (File file : files) {
                builder.append(file.getAbsolutePath()).append(", ");
            }
            return builder.substring(0, builder.length() - 2);
        }
        return emptyString;
    }

    private void saveReport(JFileChooser chooser, String extension, File report) {
        if (report == null) {
            String message = "Error! Validation doesn't appear to have run and has returned a null report.";
            DialogUtils.errorDialog(this, message, logger, new IllegalArgumentException(message));
        } else {
            chooser.setSelectedFile(new File(extension.toLowerCase() + "Report." + extension.toLowerCase()));
            int resultChoose = chooser.showSaveDialog(this);
            if (resultChoose == 0) {
                File temp = chooser.getSelectedFile();
                if (!temp.getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
                    temp = new File(temp.getPath() + "." + extension.toLowerCase());
                }
                try {
                    try {
                        Files.copy(report.toPath(), temp.toPath(), new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException excep) {
                        String message = String.format("Overwrite existing file %s?.", extension.toUpperCase());
                        logger.log(Level.FINE, message, excep);
                        int resultOption = JOptionPane.showConfirmDialog(this, message, "Confirm Overwrite", 0);
                        if (resultOption == 0) {
                            Files.copy(report.toPath(), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                catch (IOException excep) {
                    String message = String.format("IOException when saving the %S report.", extension.toUpperCase());
                    DialogUtils.errorDialog(this, message, logger, excep);
                }
            }
        }
    }

    private void changeConfig() throws JAXBException, IOException {
        if (!"Custom profile".equals(this.chooseFlavour.getSelectedItem())) {
            this.profilePath = FileSystems.getDefault().getPath(emptyString, new String[0]);
        }
        PDFAFlavour flavour = this.getCurrentFlavour();
        ValidatorConfig validatorConfig = config.getValidatorConfig();
        ValidatorConfig currentConfig = ValidatorFactory.createConfig(flavour, validatorConfig.getDefaultFlavour(), validatorConfig.isRecordPasses(), validatorConfig.getMaxFails(), validatorConfig.isDebug(), validatorConfig.isLogsEnabled(), validatorConfig.getLoggingLevel(), validatorConfig.getMaxNumberOfDisplayedFailedChecks(), validatorConfig.showErrorMessages());
        config.updateValidatorConfig(currentConfig);
        config.updateAppConfig(this.appConfigFromState());
    }

    VeraAppConfig appConfigFromState() {
        Applications.Builder builder = Applications.createConfigBuilder(config.getApplicationConfig());
        ProcessType selectedItem = (ProcessType)((Object)this.ProcessTypes.getSelectedItem());
        if (this.isFixMetadata()) {
            selectedItem = ProcessType.addProcess(selectedItem, ProcessType.FIX);
        }
        builder.type(selectedItem);
        return builder.build();
    }

    private PDFAFlavour getCurrentFlavour() {
        String selectedItem = (String)this.chooseFlavour.getSelectedItem();
        PDFAFlavour flavour = FLAVOURS_MAP.get(selectedItem);
        return flavour == null ? PDFAFlavour.NO_FLAVOUR : flavour;
    }

    private boolean isExecute() {
        return !(this.pdfsToProcess == null || this.profilePath.toString().isEmpty() && this.chooseFlavour.getSelectedItem().equals("Custom profile") || this.ProcessTypes.getSelectedItem() == ProcessType.POLICY && this.policy == null);
    }

    private boolean isFixMetadata() {
        return this.fixMetadata.isSelected();
    }

    protected static String getFlavourReadableText(PDFAFlavour flavour) {
        return String.format(flavour.getPart().getFamily() + "-%d%S", flavour.getPart().getPartNumber(), flavour.getLevel().getCode());
    }

    void setPolicyFile(File policy) {
        if (policy != null && policy.isFile() && policy.canRead()) {
            this.policy = policy;
            this.policyChooser.setSelectedFile(policy);
            this.chosenPolicy.setText(policy.getAbsolutePath());
            this.execute.setEnabled(this.isExecute());
        }
    }

    static {
        logger = Logger.getLogger(CheckerPanel.class.getCanonicalName());
        FLAVOURS_MAP = new HashMap<String, PDFAFlavour>();
    }

    public class PanelDropTargetListener
    extends DropTargetAdapter {
        private final Logger LOGGER = Logger.getLogger(PanelDropTargetListener.class.getCanonicalName());
        private static final String UNSUPPORTED_FLAVOUR = "Unsupported flavour error.";
        private static final String CASTING_ERROR = "Casting transfer to files type error.";
        private int acceptableFilesCount;
        private List<File> selectedFiles = new ArrayList<File>();
        private String[] acceptableExtensions;

        public PanelDropTargetListener(int acceptableFilesCount, String ... acceptableExtensions) {
            this.acceptableFilesCount = acceptableFilesCount;
            this.acceptableExtensions = acceptableExtensions;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if ((dtde.getDropAction() & 3) != 0) {
                try {
                    dtde.acceptDrop(dtde.getDropAction());
                    this.selectedFiles = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (this.isAcceptableTransferData(this.selectedFiles)) {
                        this.dropFiles(this.selectedFiles);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    this.LOGGER.warning(UNSUPPORTED_FLAVOUR);
                }
                catch (IOException e) {
                    this.LOGGER.warning(CASTING_ERROR);
                }
            } else {
                dtde.rejectDrop();
            }
        }

        private boolean isAcceptableTransferData(List<File> selectedFiles) {
            if (this.acceptableFilesCount != -1 && this.acceptableFilesCount != selectedFiles.size()) {
                return false;
            }
            if (selectedFiles.size() == 0) {
                return false;
            }
            return ApplicationUtils.isLegalExtension(selectedFiles, this.acceptableExtensions);
        }

        private void dropFiles(List<File> selectedFiles) {
            CheckerPanel.this.insertFilesInfo(selectedFiles, this.acceptableExtensions);
        }
    }

    private class ProcessingTypeRenderer
    extends JLabel
    implements ListCellRenderer<ProcessType> {
        private static final long serialVersionUID = -2841316639915833315L;

        public ProcessingTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ProcessType> list, ProcessType value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.getValue());
            return this;
        }
    }
}

