/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import org.verapdf.model.impl.axl.AXLXMPObject;
import org.verapdf.model.tools.xmp.SchemasDefinition;
import org.verapdf.model.tools.xmp.SchemasDefinitionCreator;
import org.verapdf.model.xmplayer.XMPProperty;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class AXLXMPProperty
extends AXLXMPObject
implements XMPProperty {
    public static final String XMP_PROPERTY_TYPE = "XMPProperty";
    protected final VeraPDFXMPNode xmpNode;
    private final boolean isMainMetadata;
    private final boolean isClosedChoiceCheck;
    private final PDFAFlavour flavour;
    private final SchemasDefinition mainPackageSchemasDefinition;
    private SchemasDefinition currentSchemasDefinitionPDFA_1;
    private SchemasDefinition currentSchemasDefinitionPDFA_2_3;

    public AXLXMPProperty(VeraPDFXMPNode xmpNode, boolean isMainMetadata, boolean isClosedChoiceCheck, SchemasDefinition mainPackageSchemasDefinition, SchemasDefinition currentSchemasDefinitionPDFA_1, SchemasDefinition currentSchemasDefinitionPDFA_2_3, PDFAFlavour flavour) {
        this(xmpNode, XMP_PROPERTY_TYPE, isMainMetadata, isClosedChoiceCheck, mainPackageSchemasDefinition, currentSchemasDefinitionPDFA_1, currentSchemasDefinitionPDFA_2_3, flavour);
    }

    protected AXLXMPProperty(VeraPDFXMPNode xmpNode, String type, boolean isMainMetadata, boolean isClosedChoiceCheck, SchemasDefinition mainPackageSchemasDefinition, SchemasDefinition currentSchemasDefinitionPDFA_1, SchemasDefinition currentSchemasDefinitionPDFA_2_3, PDFAFlavour flavour) {
        super(type);
        this.xmpNode = xmpNode;
        this.isMainMetadata = isMainMetadata;
        this.isClosedChoiceCheck = isClosedChoiceCheck;
        this.mainPackageSchemasDefinition = mainPackageSchemasDefinition;
        this.currentSchemasDefinitionPDFA_1 = currentSchemasDefinitionPDFA_1;
        this.currentSchemasDefinitionPDFA_2_3 = currentSchemasDefinitionPDFA_2_3;
        this.contextDependent = Boolean.TRUE;
        this.flavour = flavour;
    }

    @Override
    public String getID() {
        return this.xmpNode.getNamespaceURI() + " - " + this.xmpNode.getPrefix() + ":" + this.xmpNode.getName();
    }

    @Override
    public Boolean getisPredefinedInXMP2004() {
        return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_1(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisPredefinedInXMP2005() {
        return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_2_3(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisDefinedInCurrentPackage() {
        if (this.flavour != null && this.flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
            return this.currentSchemasDefinitionPDFA_1.isDefinedProperty(this.xmpNode);
        }
        return this.currentSchemasDefinitionPDFA_2_3.isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisDefinedInMainPackage() {
        return this.isMainMetadata ? Boolean.valueOf(this.currentSchemasDefinitionPDFA_2_3.isDefinedProperty(this.xmpNode)) : Boolean.valueOf(this.mainPackageSchemasDefinition.isDefinedProperty(this.xmpNode));
    }

    @Override
    public Boolean getisValueTypeCorrect() {
        if (this.xmpNode == null) {
            return Boolean.FALSE;
        }
        if (this.flavour != null && this.flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
            return this.isValueTypeCorrectForPDFA_1();
        }
        return this.isValueTypeCorrectForPDFA_2_3();
    }

    private Boolean isValueTypeCorrectForPDFA_1() {
        if (this.currentSchemasDefinitionPDFA_1.isDefinedProperty(this.xmpNode)) {
            return this.currentSchemasDefinitionPDFA_1.isCorrespondsDefinedType(this.xmpNode);
        }
        if (SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_1(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode)) {
            return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_1(this.isClosedChoiceCheck).isCorrespondsDefinedType(this.xmpNode);
        }
        return null;
    }

    private Boolean isValueTypeCorrectForPDFA_2_3() {
        if (this.currentSchemasDefinitionPDFA_2_3.isDefinedProperty(this.xmpNode)) {
            return this.currentSchemasDefinitionPDFA_2_3.isCorrespondsDefinedType(this.xmpNode);
        }
        if (this.mainPackageSchemasDefinition.isDefinedProperty(this.xmpNode)) {
            return this.mainPackageSchemasDefinition.isCorrespondsDefinedType(this.xmpNode);
        }
        if (SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_2_3(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode)) {
            return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_2_3(this.isClosedChoiceCheck).isCorrespondsDefinedType(this.xmpNode);
        }
        return null;
    }
}

