/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfbox.foundry;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.metadata.fixer.PBoxMetadataFixerImpl;
import org.verapdf.model.ModelParser;
import org.verapdf.pdfa.AbstractFoundry;
import org.verapdf.pdfa.MetadataFixer;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;

class PdfBoxFoundry
extends AbstractFoundry {
    private static final URI id = URI.create("http://pdfa.verapdf.org/Foundry#pdfbox");
    private static final ReleaseDetails pdfBoxReleaseDetails = ReleaseDetails.addDetailsFromResource("org/verapdf/release/pdfbox-validation.properties");
    private static final ComponentDetails details = Components.veraDetails(id, "VeraPDF PDFBox Foundry", pdfBoxReleaseDetails.getVersion(), "This foundry instance provides the PDF Box based validation library.");
    private static final PdfBoxFoundry instance = new PdfBoxFoundry();

    private PdfBoxFoundry() {
    }

    @Override
    public ComponentDetails getDetails() {
        return details;
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream) throws ModelParsingException, EncryptedPdfException {
        return this.createParser(pdfStream, PDFAFlavour.NO_FLAVOUR);
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return ModelParser.createModelWithFlavour(pdfStream, flavour);
    }

    @Override
    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour) throws ModelParsingException, EncryptedPdfException {
        return ModelParser.createModelWithFlavour(file, pdfaFlavour);
    }

    @Override
    public PDFAParser createParser(File file) throws ModelParsingException, EncryptedPdfException {
        return this.createParser(file, PDFAFlavour.NO_FLAVOUR);
    }

    @Override
    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return ModelParser.createModelWithFlavour(file, pdfaFlavour, defaultFlavour);
    }

    @Override
    public MetadataFixer createMetadataFixer() {
        return new PBoxMetadataFixerImpl();
    }

    @Override
    public String getParserId() {
        return "PDFBox";
    }

    public static ReleaseDetails getReleaseDetails() {
        return pdfBoxReleaseDetails;
    }

    static VeraPDFFoundry getInstance() {
        return instance;
    }

    @Override
    public void close() {
    }
}

