/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.external.PBoxJPEG2000;
import org.verapdf.model.impl.pb.pd.images.PBoxPDSMaskImage;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDSMaskImage;
import org.verapdf.model.pdlayer.PDXImage;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDXImage
extends PBoxPDXObject
implements PDXImage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDXImage.class.getCanonicalName());
    public static final String X_IMAGE_TYPE = "PDXImage";
    public static final String IMAGE_CS = "imageCS";
    public static final String ALTERNATES = "Alternates";
    public static final String INTENT = "Intent";
    public static final String JPX_STREAM = "jpxStream";
    public static final String S_MASK = "SMask";
    private final boolean interpolate;
    private List<JPEG2000> jpeg2000List = null;
    private PDColorSpace colorSpaceFromImage = null;

    public PBoxPDXImage(PDImageXObjectProxy simplePDObject, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        this(simplePDObject, resources, X_IMAGE_TYPE, document, flavour);
    }

    protected PBoxPDXImage(PDImageXObjectProxy simplePDObject, PDInheritableResources resources, String type, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, resources, type, document, flavour);
        this.interpolate = simplePDObject.getInterpolate();
    }

    @Override
    public Boolean getInterpolate() {
        return this.interpolate;
    }

    @Override
    public Boolean getcontainsAlternates() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName(ALTERNATES));
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "Alternates": {
                return this.getAlternates();
            }
            case "jpxStream": {
                return this.getJPXStream();
            }
            case "SMask": {
                return this.getSMask();
            }
        }
        return super.getLinkedObjects(link);
    }

    protected List<PDSMaskImage> getSMask() {
        try {
            PDSMaskImage xObject;
            COSStream cosStream = ((PDXObject)this.simplePDObject).getCOSStream();
            COSBase smaskDictionary = cosStream.getDictionaryObject(COSName.SMASK);
            if (smaskDictionary instanceof COSDictionary && (xObject = this.getXObject(smaskDictionary)) != null) {
                ArrayList<PDSMaskImage> mask = new ArrayList<PDSMaskImage>(1);
                mask.add(xObject);
                return Collections.unmodifiableList(mask);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problems with obtaining SMask. " + e.getMessage());
        }
        return Collections.emptyList();
    }

    private PDSMaskImage getXObject(COSBase smaskDictionary) throws IOException {
        PDXObject pbObject;
        COSName name = ((COSDictionary)smaskDictionary).getCOSName(COSName.NAME);
        String nameAsString = name != null ? name.getName() : null;
        PDResources resourcesLocal = null;
        if (this.simplePDObject instanceof PDFormXObject) {
            resourcesLocal = ((PDFormXObject)this.simplePDObject).getResources();
        }
        if ((pbObject = PDXObject.createXObject(smaskDictionary, nameAsString, resourcesLocal)) instanceof PDImageXObjectProxy) {
            return new PBoxPDSMaskImage((PDImageXObjectProxy)pbObject, this.resources, this.document, this.flavour);
        }
        LOGGER.log(Level.INFO, "SMask object is not an Image XObject");
        return null;
    }

    private List<CosRenderingIntent> getIntent() {
        COSDictionary imageStream = (COSDictionary)this.simplePDObject.getCOSObject();
        COSName intent = imageStream.getCOSName(COSName.getPDFName(INTENT));
        if (intent != null) {
            ArrayList<PBCosRenderingIntent> intents = new ArrayList<PBCosRenderingIntent>(1);
            intents.add(new PBCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }

    private List<PDColorSpace> getImageCS() {
        PDImageXObjectProxy image;
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        if (!(image = (PDImageXObjectProxy)this.simplePDObject).isStencil()) {
            try {
                PDColorSpace buffer = ColorSpaceFactory.getColorSpace(image.getColorSpace(), null, this.resources, 0, false, this.document, this.flavour);
                if (buffer == null) {
                    buffer = this.colorSpaceFromImage;
                }
                if (buffer != null) {
                    ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
                    colorSpaces.add(buffer);
                    return Collections.unmodifiableList(colorSpaces);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Could not obtain Image XObject color space. " + e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private List<? extends PDXImage> getAlternates() {
        ArrayList<PDXImage> alternates = new ArrayList<PDXImage>();
        try (COSStream imageStream = ((PDImageXObjectProxy)this.simplePDObject).getCOSStream();){
            COSBase buffer = imageStream.getDictionaryObject(COSName.getPDFName(ALTERNATES));
            this.addAlternates(alternates, buffer, ((PDImageXObjectProxy)this.simplePDObject).getResources());
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return alternates;
    }

    private void addAlternates(List<PDXImage> alternates, COSBase buffer, PDResources resourcesToAdd) {
        if (buffer instanceof COSArray) {
            for (COSBase element : (COSArray)buffer) {
                if (element instanceof COSObject) {
                    element = ((COSObject)element).getObject();
                }
                if (!(element instanceof COSDictionary)) continue;
                this.addAlternate(alternates, (COSDictionary)element, resourcesToAdd);
            }
        }
    }

    private void addAlternate(List<PDXImage> alternates, COSDictionary buffer, PDResources resourcesToAdd) {
        COSBase alternatesImages = buffer.getDictionaryObject(COSName.IMAGE);
        if (alternatesImages instanceof COSStream) {
            PDStream stream = new PDStream((COSStream)alternatesImages);
            PDImageXObjectProxy imageXObject = new PDImageXObjectProxy(stream, resourcesToAdd);
            alternates.add(new PBoxPDXImage(imageXObject, this.resources, this.document, this.flavour));
        }
    }

    private List<JPEG2000> getJPXStream() {
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        return this.jpeg2000List;
    }

    private List<JPEG2000> parseJPXStream() {
        block8: {
            List<JPEG2000> list;
            block9: {
                PDStream stream = ((PDImageXObjectProxy)this.simplePDObject).getPDStream();
                List<COSName> filters = stream.getFilters();
                if (filters == null || !filters.contains(COSName.JPX_DECODE)) break block8;
                InputStream image = stream.getStream().getFilteredStream();
                try {
                    ArrayList<PBoxJPEG2000> list2 = new ArrayList<PBoxJPEG2000>(1);
                    PBoxJPEG2000 jpeg2000 = PBoxJPEG2000.fromStream(image, this.document, this.flavour);
                    this.colorSpaceFromImage = jpeg2000.getImageColorSpace();
                    list2.add(jpeg2000);
                    list = Collections.unmodifiableList(list2);
                    if (image == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (image != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.INFO, "Problems with stream obtain. " + e.getMessage());
                    }
                }
                image.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsTransparency() {
        if (this.simplePDObject == null) {
            return false;
        }
        COSBase base = this.simplePDObject.getCOSObject();
        if (!(base instanceof COSStream)) return false;
        try (COSStream stream = (COSStream)base;){
            if (stream.getDictionaryObject(COSName.SMASK) instanceof COSStream) {
                boolean bl = true;
                return bl;
            }
            COSBase sMaskInData = stream.getDictionaryObject(COSName.getPDFName("SMaskInData"));
            if (!(sMaskInData instanceof COSNumber)) return false;
            boolean bl = ((COSNumber)sMaskInData).doubleValue() > 0.0;
            return bl;
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return false;
    }
}

