/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDStructElem;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.model.tools.TaggedPDFHelper;
import org.verapdf.model.tools.TaggedPDFRoleMapHelper;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDStructTreeRoot
extends PBoxPDObject
implements PDStructTreeRoot {
    public static final String STRUCT_TREE_ROOT_TYPE = "PDStructTreeRoot";
    public static final String CHILDREN = "K";
    public static final String ROLE_MAP_NAMES = "roleMapNames";
    private List<PDStructElem> children = null;
    private PDFAFlavour flavour;

    public PBoxPDStructTreeRoot(PDStructureTreeRoot treeRoot, PDFAFlavour flavour) {
        super(treeRoot, STRUCT_TREE_ROOT_TYPE);
        this.flavour = flavour;
    }

    @Override
    public String getkidsStandardTypes() {
        return this.getChildren().stream().map(PDStructElem::getstandardType).filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    @Override
    public Boolean gethasContentItems() {
        COSBase children = ((PDStructureTreeRoot)this.simplePDObject).getK();
        if (children != null) {
            if (PBoxPDStructElem.isContentItem(children)) {
                return true;
            }
            if (children instanceof COSArray && ((COSArray)children).size() > 0) {
                for (int i = 0; i < ((COSArray)children).size(); ++i) {
                    if (!PBoxPDStructElem.isContentItem(((COSArray)children).get(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "roleMapNames": {
                return this.getRoleMapNames();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDStructElem> getChildren() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        return this.children;
    }

    private List<PDStructElem> parseChildren() {
        COSDictionary parent = ((PDStructureTreeRoot)this.simplePDObject).getCOSObject();
        return TaggedPDFHelper.getStructTreeRootChildren(parent, new TaggedPDFRoleMapHelper(this.getRoleMap(), this.flavour));
    }

    private Map<String, String> getRoleMap() {
        Map<String, Object> tempMap = ((PDStructureTreeRoot)this.simplePDObject).getRoleMap();
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : tempMap.entrySet()) {
            resMap.put(entry.getKey(), entry.getValue().toString());
        }
        return resMap;
    }

    private List<CosUnicodeName> getRoleMapNames() {
        Map<String, Object> tempMap = ((PDStructureTreeRoot)this.simplePDObject).getRoleMap();
        if (tempMap != null) {
            ArrayList<CosUnicodeName> res = new ArrayList<CosUnicodeName>();
            for (Map.Entry<String, Object> entry : tempMap.entrySet()) {
                res.add(new PBCosUnicodeName(COSName.getPDFName(entry.getKey())));
                res.add(new PBCosUnicodeName(COSName.getPDFName(entry.getValue().toString())));
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public String gettopLevelFirstElementStandardType() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        if (!this.children.isEmpty()) {
            return this.children.get(0).getstandardType();
        }
        return null;
    }

    @Override
    public String getfirstChildStandardTypeNamespaceURL() {
        return null;
    }
}

